package cn.com.duiba.spring.boot.starter.dsp.rateLimiter;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import javax.annotation.Resource;
import java.util.Objects;

@Slf4j
public class TokenBucketLimiter {

    @Resource(name = "redis03StringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private DefaultRedisScript<Long> redisLuaScript;

    boolean acquire(String key, TokenBucketLimiterPolicy policy) {
        if (policy == null) {
            return true;
        }
        Long remain = stringRedisTemplate.execute(redisLuaScript, Lists.asList(key, new String[]{}), policy.toParams());
        return Objects.nonNull(remain) && remain > 0;
    }

}
