package cn.com.duiba.spring.boot.starter.dsp.rateLimiter;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@Aspect
@Component
public class LimitAspect {

    private final static Map<Long, Integer> redisNodeIndex = new ConcurrentHashMap<>();

    private final static Logger logger = LoggerFactory.getLogger(LimitAspect.class);

    private final static Map<String, AtomicLong> map = new ConcurrentHashMap<>();

    private final static Integer REDIS_NODE_NUM = 4;
    static {
        map.put("rate.limit:com.duiba.tuia.adx.web.service.algo.impl.AdxAlgoServiceImpl-hello-limit", new AtomicLong());

        redisNodeIndex.put(0L, 14);
        redisNodeIndex.put(1L, 18);
        redisNodeIndex.put(2L, 296);
        redisNodeIndex.put(3L, 346);
        redisNodeIndex.put(4L, 29);
        redisNodeIndex.put(5L, 21);
        redisNodeIndex.put(6L, 32);
        redisNodeIndex.put(7L, 122);
        redisNodeIndex.put(8L, 69);
        redisNodeIndex.put(9L, 65);
        redisNodeIndex.put(10L, 76);
        redisNodeIndex.put(11L, 197);
        redisNodeIndex.put(12L, 50);
        redisNodeIndex.put(13L, 58);
        redisNodeIndex.put(14L, 223);
        redisNodeIndex.put(15L, 47);
    }

    @Autowired
    private RateLimitProperties rateLimitProperties;

    @Autowired
    private TokenBucketLimiter tokenBucketLimiter;

    @Pointcut(value = "@annotation(cn.com.duiba.spring.boot.starter.dsp.rateLimiter.RateLimit)")
    public void rateLimitPointcut() {
        // 点击注解切入.
    }

    @Around(value = "rateLimitPointcut()")
    public Object interceptor(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!rateLimitProperties.isAdxRateLimitSwitch()) {
            return joinPoint.proceed();
        }

        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        Method method = signature.getMethod();
        Class<?> targetClass = method.getDeclaringClass();
        RateLimit rateLimit = method.getAnnotation(RateLimit.class);

        if (rateLimit == null) {
            return joinPoint.proceed();
        }

        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("rate.limit:").
                append(targetClass.getName()).append("-")
                .append(method.getName()).append("-")
                .append(rateLimit.key());

        String commonRedisKey = stringBuilder.toString();

        long index = map.get(commonRedisKey).getAndIncrement() % REDIS_NODE_NUM;

        String redisKey = commonRedisKey + "{" + redisNodeIndex.get(index) + "}";
        logger.info("限流啦, redis key{}", redisKey);

        long totalLimitCount = rateLimit.count();
        long limitCount = totalLimitCount % REDIS_NODE_NUM > index ? totalLimitCount / REDIS_NODE_NUM + 1 : totalLimitCount / REDIS_NODE_NUM;
        if (limitCount <= 0) {
            throw new RuntimeException("已经到设置限流次数");
        }
        TokenBucketLimiterPolicy tokenBucketLimiterPolicy = new TokenBucketLimiterPolicy(limitCount, 200);
        if (tokenBucketLimiter.acquire(redisKey, tokenBucketLimiterPolicy)) {
            return joinPoint.proceed();
        }

        //由于本文没有配置公共异常类，如果配置可替换
        throw new RuntimeException("已经到设置限流次数");
    }

}
