package cn.com.duiba.spring.boot.starter.dsp.util;

import cn.com.duiba.spring.boot.starter.dsp.enums.RedisBalance8KeyEnum;
import com.google.common.base.Stopwatch;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;

/**
 * @author jiangyangyang
 * @version 1.0
 * @description: 根据分片个数生成redis均匀的key
 * @date 2022/1/6 上午10:36
 */
public class RedisBalanceKeyUtil {

    private static final String START = "{";

    private static final String END = "}";

    /**
     * 根据前缀生成8分片的redis key
     *
     * @param prefix 前缀
     * @return redis key集合
     */
    public static List<String> createRedisBalance8key(String prefix) {
        RedisBalance8KeyEnum[] values = RedisBalance8KeyEnum.values();
        List<String> list = new ArrayList<>(values.length);
        for (RedisBalance8KeyEnum keyEnum : values) {
            String key = keyEnum.hashTag;
            String redisKey = StringUtils.join(prefix, "_", keyEnum.order, START, key, END);
            list.add(redisKey);
        }
        return list;
    }


    /**
     * 通过hash 然后取模获取指定的redis key
     *
     * @param targetStr 目标字符串
     * @return 返回指定节点对应的rediskey
     */
    public static String getRedisBalance8key(String prefix, String targetStr) {
        String HashStr = DigestUtils.md5Hex(targetStr);
        int targetHashValue = HashAlgorithm.dekHash(HashStr);
        RedisBalance8KeyEnum[] values = RedisBalance8KeyEnum.values();
        int mold = targetHashValue % (values.length);
        for (RedisBalance8KeyEnum keyEnum : values) {
            if (Objects.equals(keyEnum.order, mold)) {
                String key = keyEnum.hashTag;
                return StringUtils.join(prefix, "_", keyEnum.order, START, key, END);
            }
        }
        return null;
    }

    /**
     * 通过hash 然后取模获取指定的redis的suffix
     *
     * @param targetStr 目标字符串
     * @return 返回指定节点对应的rediskey
     */
    public static String getRedisBalance8keySuffix(String targetStr) {
        String HashStr = DigestUtils.md5Hex(targetStr);
        int targetHashValue = HashAlgorithm.dekHash(HashStr);
        RedisBalance8KeyEnum[] values = RedisBalance8KeyEnum.values();
        int mold = targetHashValue % (values.length);
        for (RedisBalance8KeyEnum keyEnum : values) {
            if (Objects.equals(keyEnum.order, mold)) {
                String key = keyEnum.hashTag;
                return StringUtils.join(keyEnum.order, START, key, END);
            }
        }
        return null;
    }

    /**
     * getRedisBalance8key的非hash版
     * 从目标字符串中获取从左到右第一个数字并且取模得到redisKey
     *
     * @param targetStr 目标字符串
     * @return 返回指定节点对应的rediskey
     */
    public static String getRedisKeyByFirstNumMold(String prefix, String targetStr) {
        int randomNum = 0;
        for (int i = 0; i < targetStr.length(); i++) {
            char c = targetStr.charAt(i);
            if (c >= 48 && c <= 57) {
                randomNum = c;
                break;
            }
        }
        RedisBalance8KeyEnum[] values = RedisBalance8KeyEnum.values();
        int mold = randomNum % (values.length);
        for (RedisBalance8KeyEnum keyEnum : values) {
            if (Objects.equals(keyEnum.order, mold)) {
                String key = keyEnum.hashTag;
                return StringUtils.join(prefix, "_", keyEnum.order, START, key, END);
            }
        }
        return null;
    }

    /**
     * getRedisBalance8keySuffix的非hash版
     * 从目标字符串中获取从左到右第一个数字并且取模得到redisKey
     *
     * @param targetStr 目标字符串
     * @return 返回指定节点对应的rediskey
     */
    public static String getRedisSuffixByFirstNumMold(String targetStr) {
        int randomNum = 0;
        for (int i = 0; i < targetStr.length(); i++) {
            char c = targetStr.charAt(i);
            if (c >= 48 && c <= 57) {
                randomNum = c;
                break;
            }
        }
        RedisBalance8KeyEnum[] values = RedisBalance8KeyEnum.values();
        int mold = randomNum % (values.length);
        for (RedisBalance8KeyEnum keyEnum : values) {
            if (Objects.equals(keyEnum.order, mold)) {
                String key = keyEnum.hashTag;
                return StringUtils.join(keyEnum.order, START, key, END);
            }
        }
        return null;
    }

    /**
     * getRedisBalance8keySuffix的非hash版
     * 从目标字符串中获取从左到右第一个数字或字母并且取模得到redisKey
     *
     * @param targetStr 目标字符串
     * @return 返回指定节点对应的rediskey
     */
    public static String getRedisSuffixByFirstCharacterMold(String targetStr) {
        int randomNum = targetStr.charAt(0);
        RedisBalance8KeyEnum[] values = RedisBalance8KeyEnum.values();
        int mold = randomNum % (values.length);
        for (RedisBalance8KeyEnum keyEnum : values) {
            if (Objects.equals(keyEnum.order, mold)) {
                String key = keyEnum.hashTag;
                return StringUtils.join(keyEnum.order, START, key, END);
            }
        }
        return null;
    }


}
