package cn.com.duiba.spring.boot.starter.dsp.sampler;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;

public class SamplerLog {

    private static final Logger logger = LoggerFactory.getLogger(SamplerLog.class);

    private static final TransmittableThreadLocal<String> LOCAL = new TransmittableThreadLocal<>();

    private static final Random random = new Random();

    public static void start(Integer samplingRate){
        if (random.nextInt(samplingRate) != 0) {
            return;
        }
        LOCAL.set(UUID.randomUUID().toString());
    }

    public static void end(){
        LOCAL.remove();
    }

    public static String getSamplerId(){
        return LOCAL.get();
    }

    public static void setSamplerId(String samplerId) {
        LOCAL.set(samplerId);
    }

    public static boolean infoFlag() {
        return Objects.nonNull(LOCAL.get());
    }

    public static void info(String format, Object... arguments) {
        try {
            if (infoFlag()) {
                logger.info("samplingId-" + LOCAL.get() + "," + format, arguments);
            }
        } catch (Exception e) {
            logger.warn("SamplerLog info error", e);
        }
    }

}
