package cn.com.duiba.spring.boot.starter.dsp.sampler;

import cn.com.duiba.spring.boot.starter.dsp.sampler.converter.ApolloPanGuConverter;
import cn.com.duiba.spring.boot.starter.dsp.sampler.converter.SamplerLogConverter;
import cn.com.duiba.spring.boot.starter.dsp.sampler.feign.SamplerLogRequestInterceptor;
import cn.com.duiba.spring.boot.starter.dsp.sampler.filter.DubboLogSamplerContextFilter;
import cn.com.duiba.spring.boot.starter.dsp.sampler.filter.RpcLogSamplerContextFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * @author jiangyangyang
 * @version 1.0
 * @description: 抽样日志全部配置
 * @date 2022/3/4 下午4:23
 */
public class SamplerLogAutoConfiguration {

    //获取样本数默认实现，盘古实现
    @Bean
    @ConditionalOnMissingBean(SamplerLogConverter.class)
    public ApolloPanGuConverter apolloPanGuConverter() {
        return new ApolloPanGuConverter();
    }

    //feign调用拦截器，主要设置请求头
    @Bean
    public SamplerLogRequestInterceptor customRequestInterceptor() {
        return new SamplerLogRequestInterceptor();
    }

    //dubbo服务调用过滤器，设置请求头和接收请求头
    @Bean
    public DubboLogSamplerContextFilter dubboLogSamplerContextFilter() {
        return new DubboLogSamplerContextFilter();
    }

    //servlet过滤器
    @Bean
    public RpcLogSamplerContextFilter rpcLogSamplerContextFilter() {
        return new RpcLogSamplerContextFilter();
    }

    //抽样日志打印核心工具类
    @Bean
    public SamplerLog samplerLog() {
        return new SamplerLog();
    }
}
