package cn.com.duiba.spring.boot.starter.dsp.sampler;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;

public class SamplerLogThreadLocal {

    private static final Random random = new Random();

    private static final TransmittableThreadLocal<SamplerLogContext> logSamplerTracerThreadLocal = new TransmittableThreadLocal<>();

    static TransmittableThreadLocal<SamplerLogContext> getContext() {
        return logSamplerTracerThreadLocal;
    }

    static void setSamplingRate(Integer samplingRate) {
        if (Objects.isNull(samplingRate)) {
            set(false, null);
            return;
        }

        if (random.nextInt(samplingRate) == 0) {
            set(true, UUID.randomUUID().toString());
            return;
        }
        set(false, null);
    }

    static void set(boolean isPrint, String samplingId) {
        SamplerLogContext logSamplerContext = new SamplerLogContext();
        logSamplerContext.setPrintLogFlag(isPrint);
        logSamplerContext.setSamplingId(samplingId);
        logSamplerTracerThreadLocal.set(logSamplerContext);
    }

}
