package cn.com.duiba.spring.boot.starter.dsp.sampler;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Objects;

public class SamplerLog {

    private static final Logger logger = LoggerFactory.getLogger(SamplerLog.class);

    public static void startSampling(Integer samplingRate){
        SamplerLogThreadLocal.setSamplingRate(samplingRate);
    }

    public static boolean infoFlag() {
        TransmittableThreadLocal<SamplerLogContext> threadLocal = SamplerLogThreadLocal.getContext();

        if (Objects.isNull(threadLocal) || Objects.isNull(threadLocal.get()) || Objects.isNull(threadLocal.get().getPrintLogFlag())) {
            return false;
        }

        return threadLocal.get().getPrintLogFlag();
    }

    public static void info(String format, Object... arguments) {
        if (infoFlag()) {
            logger.info("samplingId-" + SamplerLogThreadLocal.getContext().get().getSamplingId() + "，" + format, arguments);
        }
    }




}
