package cn.com.duiba.spring.boot.starter.dsp.sampler;

import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.*;
import java.util.Objects;

@Slf4j
@Activate(group = {CommonConstants.CONSUMER, CommonConstants.PROVIDER}, order = -2000)
public class DubboLogSamplerContextFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        boolean isConsumerSide = Objects.equals(sideKey, CommonConstants.CONSUMER);

        // 1、判断是消费者还是服务提供者
        if (isConsumerSide) {
            // 如果是消费者，将打印日志标识符set至上下文中
            RpcContext.getContext().setAttachment(SamplerLogConstant.DUBBO_PRINT_LOG_FLAG, String.valueOf(SamplerLogThreadLocal.getContext().get().getPrintLogFlag()));
            RpcContext.getContext().setAttachment(SamplerLogConstant.DUBBO_SAMPLING_ID, String.valueOf(SamplerLogThreadLocal.getContext().get().getSamplingId()));
        } else {
            // 如果是服务提供者，从上下文取出
            String traceContext = RpcContext.getContext().getAttachment(SamplerLogConstant.DUBBO_PRINT_LOG_FLAG);
            String traceId = RpcContext.getContext().getAttachment(SamplerLogConstant.DUBBO_SAMPLING_ID);
            SamplerLogThreadLocal.set(Objects.equals("true", traceContext), traceId);
        }

        try {
            return invoker.invoke(invocation);
        } catch (Exception e) {
            if (!(e instanceof RpcException)) {
                log.warn("DubboLogSamplerContextFilter invoke warn", e);
            }
        }
        return null;

    }

}
