package cn.com.duiba.spring.boot.starter.dsp.sampler;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import java.util.Objects;

@Slf4j
@Component
public class CustomRequestInterceptor implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {

        SamplerLogContext logSamplerTracer = SamplerLogThreadLocal.getContext().get();
        if (Objects.isNull(logSamplerTracer) || Objects.isNull(logSamplerTracer.getPrintLogFlag())) {
            return;
        }
        if (logSamplerTracer.getPrintLogFlag()) {
            template.header(SamplerLogConstant.RPC_SAMPLING_ID, logSamplerTracer.getSamplingId());
        }
        template.header(SamplerLogConstant.RPC_PRINT_LOG_FLAG, logSamplerTracer.getPrintLogFlag().toString());
    }

}
