package cn.com.duiba.spring.boot.starter.dsp.sampler.filter;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.sampler.constants.SamplerLogConstant;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * @author jiangyangyang
 * @version 1.0
 * @description: rpc调用抽样日志过滤器
 * @date 2022/3/4 上午10:55
 */
public class RpcLogSamplerContextFilter implements Filter {

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest) request;
        String samplerId = httpServletRequest.getHeader(SamplerLogConstant.RPC_SAMPLING_ID);
        if (StringUtils.isNotEmpty(samplerId)) {
            SamplerLog.setSamplerId(samplerId);
        }
        try {
            chain.doFilter(request, response);
        } finally {
            if (SamplerLog.infoFlag()) {
                SamplerLog.end();
            }
        }
    }
}
