package cn.com.duiba.spring.boot.starter.dsp.sampler.converter;

import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author jiangyangyang
 * @version 1.0
 * @description:
 * @date 2022/3/4 下午2:30
 */
public class ApolloPanGuConverter implements SamplerLogConverter {

    private static final Logger logger = LoggerFactory.getLogger(ApolloPanGuConverter.class);

    @Resource
    private ApolloPanGuService apolloPanGuService;

    @Value("${spring.application.name}")
    private String applicationName;

    /**
     * 广告位：slot
     * 媒体：app
     * adx：adx
     *
     * @param type
     * @param value
     * @return
     */
    public Integer getSampling(String type, String value) {
        String panGuKey = applicationName + "_" + type;
        Map<String, String> samplingMap = null;
        try {
            samplingMap = apolloPanGuService.getIdMapByKeyStr(panGuKey);
        }catch (Exception e){
            logger.info("盘古获取样本数异常");
        }
        if (MapUtil.isEmpty(samplingMap)) {
            return null;
        }
        String samplingStr = samplingMap.get(value);
        if (StringUtils.isEmpty(samplingStr) || !NumberUtil.isNumber(samplingStr)) {
            return null;
        }
        return Integer.parseInt(samplingStr);
    }
}
