package cn.com.duiba.spring.boot.starter.dsp.warmup;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

@Slf4j
public class HttpRequestUtils {

    /**
     * 发送get请求
     * @param url
     * @param param
     * @return
     */
    public static String sendHttp(String url , Map<String, String> param, String appName){
        CloseableHttpClient httpClient = HttpClientBuilder.create()
                .setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).setConnectionRequestTimeout(10000).build())
                .setMaxConnPerRoute(1)
                .setMaxConnTotal(1000)
                .evictExpiredConnections()//开启后台线程定时清理失效的连接，每隔10秒主动扫描并逐出超时的连接（超过keepAliveTimeout）
                .setUserAgent(appName)
                .setRetryHandler(new DefaultHttpRequestRetryHandler())  // 默认开启重试机制，重试3次
                .disableCookieManagement()
                .useSystemProperties()//for proxy
                .disableRedirectHandling()
                .setKeepAliveStrategy(new DefaultConnectionKeepAliveStrategy(){
                    @Override
                    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                        long time = super.getKeepAliveDuration(response, context);
                        if(time == -1){
                            time = 30000;//链接最多空闲30秒
                        }
                        return time;
                    }
                })
                .build();
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            // 创建uri
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();

            // 创建http GET请求
            HttpGet httpGet = new HttpGet(uri);

            // 执行请求
            response = httpClient.execute(httpGet);
            // 判断返回状态是否为200
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString(response.getEntity(), "UTF-8");
            }else {
                log.warn("Cache preheating failed，because response {}", JSON.toJSONString(response, SerializerFeature.PrettyFormat));
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }


}
