package cn.com.duiba.spring.boot.starter.dsp.sampler;

import cn.com.duiba.spring.boot.starter.dsp.sampler.constants.SamplerLogProperties;
import cn.com.duiba.spring.boot.starter.dsp.sampler.converter.SamplerLogConverter;
import cn.hutool.core.lang.UUID;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Objects;
import java.util.Random;

@RefreshScope
public class SamplerLog {

    private static final Logger logger = LoggerFactory.getLogger(SamplerLog.class);

    private static final TransmittableThreadLocal<String> LOCAL = new TransmittableThreadLocal<>();

    private static final Random random = new Random();

    @Resource
    private SamplerLogConverter samplerLogConverter;

    @Resource
    private SamplerLogProperties samplerLogProperties;

    private static SamplerLog samplerLog;


    /**
     * 根据不同类型的业务需求对应的抽样比动态设置日志打印标识
     *
     * @param type  业务类型
     * @param value 业务类型对应的值
     */
    public static void start(String type, String value) {
        if (infoFlag()) {
            return;
        }
        Integer sampling = samplerLog.samplerLogConverter.getSampling(type, value);
        sampling = sampling == null ? samplerLog.samplerLogProperties.getDefaultSize() : sampling;
        if (random.nextInt(sampling) == 0) {
            LOCAL.set(UUID.randomUUID().toString(true));
        }
    }

    /**
     * 根据默认的抽样比设置日志打印标识
     */
    public static void start() {
        if (infoFlag()) {
            return;
        }
        if (random.nextInt(samplerLog.samplerLogProperties.getDefaultSize()) == 0) {
            LOCAL.set(UUID.randomUUID().toString(true));
        }
    }


    /**
     * info日志打印
     *
     * @param format
     * @param arguments
     */
    public static void info(String format, Object... arguments) {
        try {
            if (infoFlag()) {
                logger.info("samplingId-" + LOCAL.get() + "," + format, arguments);
            }
        } catch (Exception e) {
            logger.warn("SamplerLog info error", e);
        }
    }

    /**
     * info日志是否全量打印
     *
     * @param fullFlag
     * @param format
     * @param arguments
     */
    public static void info(boolean fullFlag, String format, Object... arguments) {
        if (fullFlag) {
            logger.info(format, arguments);
            return;
        }
        info(format, arguments);
    }

    public static void warn(String format, Object... arguments) {
        try {
            if (infoFlag()) {
                logger.warn("samplingId-" + LOCAL.get() + "," + format, arguments);
            }
        } catch (Exception e) {
            logger.warn("SamplerLog info error", e);
        }
    }

    public static void warn(boolean fullFlag, String format, Object... arguments) {
        if (fullFlag) {
            logger.warn(format, arguments);
            return;
        }
        warn(format, arguments);
    }

    public static void end() {
        LOCAL.remove();
    }

    public static String getSamplerId() {
        return LOCAL.get();
    }

    public static void setSamplerId(String samplerId) {
        LOCAL.set(samplerId);
    }

    public static boolean infoFlag() {
        return Objects.nonNull(LOCAL.get());
    }

    @PostConstruct
    public void init() {
        samplerLog = this;
    }
}
