"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloudRequest = exports.myRequest = exports.isLoading = exports.strategyEname = exports.getTmallMemberStatus = exports.AudioModel = exports.promisifyApiToTb = exports.promisifyApi = exports.promisifyApiSimple = void 0;
var tb_1 = require("../core/tb");
/**
 * 简易API封装
 * @param methodName
 * @param params
 * @param name
 */
var promisifyApiSimple = function (methodName, params, name, Taro) {
    // @ts-ignore
    var _Taro = Taro || my;
    if (name) {
        _Taro[methodName](name, params);
        return;
    }
    _Taro[methodName](params);
};
exports.promisifyApiSimple = promisifyApiSimple;
/**
 * 通用API封装
 * @param methodName
 * @param params
 */
var promisifyApi = function (methodName, params, Taro) {
    if (params === void 0) { params = {}; }
    // @ts-ignore
    var _Taro = Taro || my;
    return new Promise(function (resolve, reject) {
        _Taro[methodName](__assign(__assign({}, params), { success: function (res) {
                resolve(res);
            }, fail: function (err) {
                reject(err);
            } }));
    });
};
exports.promisifyApi = promisifyApi;
/**
 * 通用API封装
 * @param methodName
 * @param params
 */
var promisifyApiToTb = function (methodName, params, Taro) {
    if (params === void 0) { params = {}; }
    // @ts-ignore
    var _Taro = Taro || my;
    return new Promise(function (resolve, reject) {
        // @ts-ignore
        _Taro.tb[methodName](__assign(__assign({}, params), { success: function (res) {
                resolve(res);
            }, fail: function (err) {
                reject(err);
            } }));
    });
};
exports.promisifyApiToTb = promisifyApiToTb;
/**
 * 创建音频类
 */
var AudioModel = /** @class */ (function () {
    function AudioModel(opts) {
        var Taro = opts.Taro, src = opts.src;
        if (!src) {
            console.error('请输入音频链接');
            return false;
        }
        try {
            // @ts-ignore
            var _Taro = Taro || my;
            var innerAudioContext_1 = _Taro.createInnerAudioContext();
            Object.keys(opts).forEach(function (item) {
                innerAudioContext_1[item] = opts[item];
            });
            return innerAudioContext_1;
        }
        catch (e) {
            console.error('当前版本不支持音频');
        }
    }
    return AudioModel;
}());
exports.AudioModel = AudioModel;
/**
 * 获取天猫会员状态
 */
var getTmallMemberStatus = function () { return __awaiter(void 0, void 0, void 0, function () {
    var cloud;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                cloud = app.cloud;
                return [4 /*yield*/, cloud.topApi.invoke({
                        api: "tmall.campus.industry.app.audit.query",
                        data: {
                            source: "duibajk",
                        },
                    }).catch(function (err) {
                        console.log(err);
                    })];
            case 1: return [2 /*return*/, (_a.sent()) || {}];
        }
    });
}); };
exports.getTmallMemberStatus = getTmallMemberStatus;
/**
 * 拉菲奖品发放
 * @param params
 */
var strategyEname = function (params) { return __awaiter(void 0, void 0, void 0, function () {
    var cloud;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                cloud = app.cloud;
                return [4 /*yield*/, cloud.topApi.invoke({
                        api: "alibaba.latour.strategy.issue",
                        data: {
                            channel: params.channel || "",
                            strategy_code: params.strategyCode || "",
                            selected_benefit_code: params.code || "",
                        },
                    }).catch(function (err) {
                        console.log("err", err);
                    })];
            case 1: return [2 /*return*/, (_a.sent()) || {}];
        }
    });
}); };
exports.strategyEname = strategyEname;
/**
 * loading
 * @param methodName
 * @param params
 * @param name
 */
var isLoading = function (methodName) {
    // @ts-ignore
    my[methodName]();
};
exports.isLoading = isLoading;
/**
 * 数据请求
 * @param params
 * @param loading
 */
var myRequest = function (params, loading) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, new Promise(function (resolve, reject) {
                // @ts-ignore
                my.request(params).then(function (_a) {
                    var res = _a.data;
                    console.log("\u8C03\u7528mock\u63A5\u53E3\u8FD4\u56DE\u7ED3\u679C", res);
                    loading && exports.isLoading('hideLoading');
                    if (res && !res.success) {
                        tb_1.commonToast(res.message || '系统错误');
                    }
                    resolve(res);
                    return res;
                }).catch(function (e) {
                    loading && exports.isLoading('hideLoading');
                    console.log(e);
                    reject();
                });
            })];
    });
}); };
exports.myRequest = myRequest;
/**
 * 云函数接口请求
 * @param _cloudName
 * @param handle
 * @param params
 * @param loading
 * @param toastError
 */
var cloudRequest = function (cloud, _cloudName, handle, params, loading, toastError) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, new Promise(function (resolve, reject) {
                // @ts-ignore
                loading && exports.isLoading('showLoading');
                cloud.function.invoke(_cloudName, params, handle).then(function (res) {
                    console.log("%c" + handle + " \u53C2\u6570 ----->", 'color: #43bb88;font-size: 12px;', params);
                    console.log("%c" + handle + " \u8FD4\u56DE\u503C ----->", 'color: #43bb88;font-size: 12px;', res);
                    loading && exports.isLoading('hideLoading');
                    if (res && !res.success && toastError) {
                        tb_1.commonToast(res.message || '系统错误');
                    }
                    resolve(res);
                    return res;
                }).catch(function (err) {
                    console.log(handle + " catch ----->", params, err);
                    loading && exports.isLoading('hideLoading');
                    reject();
                });
            })];
    });
}); };
exports.cloudRequest = cloudRequest;
//# sourceMappingURL=index.js.map