"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authorize = exports.getAuthUserInfo = exports.openSetting = exports.getSetting = exports.confirmCustomOrder = exports.hideSkuModal = exports.showSkuModal = exports.openMessage = exports.taobaoReportClick = exports.removeStorage = exports.setStorage = exports.getStorage = exports.hideShareMenu = exports.showSharePanel = exports.setClipboard = exports.getImageInfo = exports.createAudio = exports.openDetail = exports.checkGoodsCollectedStatus = exports.collectGoods = exports.getServerTime = exports.redirectTo = exports.navigateBack = exports.navigateTo = exports.navigateToOutside = exports.checkShopFavoredStatus = exports.favorShop = exports.getSystemInfo = exports.commonConfirm = exports.simpleAlert = exports.showToast = exports.commonToast = void 0;
var helpers_1 = require("../helpers");
/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
var commonToast = function (content, duration, successCb) {
    helpers_1.promisifyApiSimple('showToast', {
        content: content || '换个姿势再试一次~',
        duration: duration || 3000,
        success: successCb
    });
};
exports.commonToast = commonToast;
/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
var showToast = function (params, Taro) {
    var _a;
    var content = params.content, duration = params.duration, success = params.success;
    helpers_1.promisifyApiSimple('showToast', (_a = {},
        _a[Taro ? 'title' : 'content'] = content || '换个姿势再试一次~',
        _a.duration = duration || 3000,
        _a.success = success,
        _a), null, Taro);
};
exports.showToast = showToast;
/**
 * 简易alert
 * @param {string} content toast内容
 */
var simpleAlert = function (content, Taro) {
    helpers_1.promisifyApiSimple('alert', {
        content: content
    }, null, Taro);
};
exports.simpleAlert = simpleAlert;
/**
 * 通用确认弹窗
 * @param {string} title 标题
 * @param {string} content 内容
 * @param {function} successCb 成功回调
 */
var commonConfirm = function (title, content, successCb, Taro) {
    if (title === void 0) { title = '提示'; }
    return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            helpers_1.promisifyApiSimple('confirm', {
                title: title,
                content: content,
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                success: function (result) {
                    var confirm = result.confirm;
                    if (confirm) {
                        successCb && successCb();
                    }
                }
            }, null, Taro);
            return [2 /*return*/];
        });
    });
};
exports.commonConfirm = commonConfirm;
/**
 * 获取系统信息
 */
var getSystemInfo = function (Taro) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('getSystemInfo', {}, Taro)];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.getSystemInfo = getSystemInfo;
/**
 * 执行关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
var favorShop = function (sellerId, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!sellerId) {
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('favorShop', { id: +sellerId }, Taro)];
            case 1:
                result = _a.sent();
                if ((result === null || result === void 0 ? void 0 : result.error) === 11)
                    return [2 /*return*/, false];
                if ((result === null || result === void 0 ? void 0 : result.error) === 12)
                    return [2 /*return*/, true];
                return [2 /*return*/, result];
        }
    });
}); };
exports.favorShop = favorShop;
/**
 * 判断是否关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
var checkShopFavoredStatus = function (sellerId, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!sellerId) {
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('checkShopFavoredStatus', { id: +sellerId }, Taro)];
            case 1:
                result = _a.sent();
                if ((result === null || result === void 0 ? void 0 : result.isFavor) !== undefined)
                    return [2 /*return*/, result.isFavor];
                if (result === 'checkShopFavoredStatus 仅支持真机调用，请在手机淘宝中运行')
                    return [2 /*return*/, true];
                return [2 /*return*/, result];
        }
    });
}); };
exports.checkShopFavoredStatus = checkShopFavoredStatus;
/**
 * 跳转到外部链接
 * @param {string} url 跳转链接
 */
var navigateToOutside = function (url, Taro) {
    if (!url) {
        console.error('navigateToOutside: 请传入url');
        return false;
    }
    helpers_1.promisifyApiSimple('call', {
        url: url
    }, 'navigateToOutside', Taro);
};
exports.navigateToOutside = navigateToOutside;
/**
 * 跳转到内部链接（新开窗口）
 * @param {string} url 跳转链接
 */
var navigateTo = function (url, Taro) {
    if (!url) {
        console.error('navigateTo: 请传入url');
        return false;
    }
    helpers_1.promisifyApiSimple('navigateTo', {
        url: url
    }, null, Taro);
};
exports.navigateTo = navigateTo;
/**
 * 返回页面
 * @param {number} delta
 */
var navigateBack = function (delta, Taro) {
    helpers_1.promisifyApiSimple('navigateBack', {
        delta: delta
    }, null, Taro);
};
exports.navigateBack = navigateBack;
/**
 * 跳转到内部链接（不新开窗口）
 * @param {string} url
 */
var redirectTo = function (url, Taro) {
    if (!url) {
        console.error('redirectTo: 请传入url');
        return false;
    }
    helpers_1.promisifyApiSimple('redirectTo', {
        url: url
    }, null, Taro);
};
exports.redirectTo = redirectTo;
/**
 * 获取服务器时间
 * @returns {number} 服务器时间戳
 */
var getServerTime = function (Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('getServerTime', {}, Taro)];
            case 1:
                result = _a.sent();
                if (result === null || result === void 0 ? void 0 : result.time)
                    return [2 /*return*/, result.time];
                return [2 /*return*/, result];
        }
    });
}); };
exports.getServerTime = getServerTime;
/**
 * 收藏商品
 * @param {number} 商品id
 * @returns {object} 收藏结果
 */
var collectGoods = function (id, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!id) {
                    console.error('collectGoods: 请传入商品id');
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('collectGoods', { id: +id }, Taro)];
            case 1:
                result = _a.sent();
                if ((result === null || result === void 0 ? void 0 : result.error) === 11)
                    return [2 /*return*/, false];
                return [2 /*return*/, result];
        }
    });
}); };
exports.collectGoods = collectGoods;
/**
 * 查询商品收藏状态
 * @param {number} 商品id
 * @returns {boolean} 商品收场状态
 */
var checkGoodsCollectedStatus = function (id, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!id) {
                    console.error('checkGoodsCollectedStatus: 请传入商品id');
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('checkGoodsCollectedStatus', { id: +id }, Taro)];
            case 1:
                result = _a.sent();
                if (result === null || result === void 0 ? void 0 : result.isCollect)
                    return [2 /*return*/, result.isCollect];
                return [2 /*return*/, result];
        }
    });
}); };
exports.checkGoodsCollectedStatus = checkGoodsCollectedStatus;
/**
 * 跳转到淘宝商品页
 * @param {string} itemId 商品ID
 */
var openDetail = function (itemId, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!itemId) {
                    console.error('openDetail: 请传入商品id');
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('openDetail', { itemId: String(itemId) }, Taro)];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.openDetail = openDetail;
/**
 * 创建音频实例
 * @param {object} opts 配置对象 例 { src: '音频链接', autoplay: false }
 */
var createAudio = function (opts, Taro) {
    var audioInstance = new helpers_1.AudioModel(__assign({ Taro: Taro }, opts));
    return audioInstance;
};
exports.createAudio = createAudio;
/**
 * 获取图片信息
 * @param {string} src 图片地址
 */
var getImageInfo = function (src, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('getImageInfo', { src: src }, Taro)];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.getImageInfo = getImageInfo;
/**
 * 剪切板
 * @param {text: string}
 */
var setClipboard = function (text, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('setClipboard', { text: text }, Taro)];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.setClipboard = setClipboard;
/**
 * 调起分享面板
 */
var showSharePanel = function (Taro) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        helpers_1.promisifyApiSimple('showSharePanel', {}, null, Taro);
        return [2 /*return*/];
    });
}); };
exports.showSharePanel = showSharePanel;
/**
 * 隐藏分享面板
 */
var hideShareMenu = function (Taro) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        helpers_1.promisifyApiSimple('hideShareMenu', {}, null, Taro);
        return [2 /*return*/];
    });
}); };
exports.hideShareMenu = hideShareMenu;
/**
 * 获取缓存数据
 * @param key
 */
var getStorage = function (key, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('getStorage', { key: key }, Taro)];
            case 1:
                result = _a.sent();
                if (result === null || result === void 0 ? void 0 : result.data)
                    return [2 /*return*/, result.data];
                return [2 /*return*/, undefined];
        }
    });
}); };
exports.getStorage = getStorage;
/**
 * 设置缓存数据
 * @param key
 * @param value
 */
var setStorage = function (key, value, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('setStorage', { key: key, data: value }, Taro)];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.setStorage = setStorage;
/**
 * 清除缓存数据
 * @param key
 */
var removeStorage = function (key, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('removeStorage', { key: key }, Taro)];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.removeStorage = removeStorage;
/**
 * 自定义分析数据的上报接口
 * @param eventType
 * @param logkey
 */
var taobaoReportClick = function (eventType, logkey) {
    // @ts-ignore
    my.reportAnalytics(eventType, {
        // 标志某一类事件，方便数据分析进行分组
        'logkey': logkey
    });
};
exports.taobaoReportClick = taobaoReportClick;
/**
 * 打开BC客服聊天
 * @param sellerNick
 * @param itemId
 */
var openMessage = function (param, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var sellerNick, itemId, result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                sellerNick = param.sellerNick, itemId = param.itemId;
                return [4 /*yield*/, helpers_1.promisifyApiToTb('openMessage', { sellerNick: sellerNick, forceH5: false, params: { itemId: itemId } }, Taro)];
            case 1:
                result = _a.sent();
                return [2 /*return*/, result];
        }
    });
}); };
exports.openMessage = openMessage;
/**
 * 显示指定商品 SKU 选择器
 * @param itemId
 */
var showSkuModal = function (itemId, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApiToTb('showSku', { itemId: itemId }, Taro)];
            case 1:
                result = _a.sent();
                return [2 /*return*/, result];
        }
    });
}); };
exports.showSkuModal = showSkuModal;
/**
 * 隐藏正在展示的商品 SKU 选择器
 */
var hideSkuModal = function (Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApiToTb('hideSku', {}, Taro)];
            case 1:
                result = _a.sent();
                return [2 /*return*/, result];
        }
    });
}); };
exports.hideSkuModal = hideSkuModal;
/**
 * 跳转订单页
 * @param itemId
 * @param skuId
 * @param quantity
 */
var confirmCustomOrder = function (param, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var itemId, skuId, quantity, result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                itemId = param.itemId, skuId = param.skuId, quantity = param.quantity;
                return [4 /*yield*/, helpers_1.promisifyApiToTb('confirmCustomOrder', {
                        data: {
                            itemId: itemId,
                            skuId: skuId || -1,
                            quantity: quantity || 1,
                            customization: {}
                        }
                    }, Taro)];
            case 1:
                result = _a.sent();
                return [2 /*return*/, result];
        }
    });
}); };
exports.confirmCustomOrder = confirmCustomOrder;
// 获取授权信息
var getSetting = function (Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var _Taro;
    return __generator(this, function (_a) {
        _Taro = Taro || my;
        return [2 /*return*/, new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    _Taro.getSetting({
                        success: function (res) {
                            resolve(res);
                        },
                    });
                    return [2 /*return*/];
                });
            }); })];
    });
}); };
exports.getSetting = getSetting;
// 打开授权设置
var openSetting = function (Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var _Taro;
    return __generator(this, function (_a) {
        _Taro = Taro || my;
        return [2 /*return*/, new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    _Taro.openSetting({
                        success: function (res) {
                            resolve(res);
                        },
                    });
                    return [2 /*return*/];
                });
            }); })];
    });
}); };
exports.openSetting = openSetting;
// 获取用户信息
var getAuthUserInfo = function (Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var _Taro;
    return __generator(this, function (_a) {
        _Taro = Taro || my;
        return [2 /*return*/, new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    _Taro.getAuthUserInfo({
                        success: function (res) {
                            resolve(res);
                        },
                    });
                    return [2 /*return*/];
                });
            }); })];
    });
}); };
exports.getAuthUserInfo = getAuthUserInfo;
// 发起用户授权{ groupChat: 群聊, userInfo: 用户基本信息, addressList: 地址列表, clipboard: 粘贴 }
var authorize = function (scopeInfo, Taro) { return __awaiter(void 0, void 0, void 0, function () {
    var _Taro;
    return __generator(this, function (_a) {
        _Taro = Taro || my;
        return [2 /*return*/, new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    _Taro.authorize({
                        scopes: scopeInfo || 'scope.userInfo',
                        success: function (res) {
                            resolve(res);
                        },
                        fail: function (err) {
                            reject(err);
                        }
                    });
                    return [2 /*return*/];
                });
            }); })];
    });
}); };
exports.authorize = authorize;
//# sourceMappingURL=tb.js.map