/**
 * 获取淘宝用户收货地址
 */
export declare const getUserAddress: (opts?: {}) => Promise<unknown>;
/**
 * 选择图片
 * @param opts
 */
export declare const chooseImage: (opts?: {}) => Promise<unknown>;
/**
 * 获取图片信息
 * @param {*} opts chooseImage配置参数
 */
export declare const uploadImage: (opts?: {}) => Promise<any>;
/**
 * 获取授权用户信息
 * @returns {object} 用户登录信息
 */
export declare const getAuthUserInfo: () => Promise<unknown>;
/**
 * 获取用户会员状态(Tmall使用)
 */
export declare const getUserStatus: () => Promise<unknown>;
/**
 * 拉菲奖品发放(Tmall使用)
 * @param params
 */
export declare const cloudTBIssue: (params: {
    channel: string;
    strategyCode: string;
    code: string;
}) => Promise<unknown>;
/**
 * 分享到群聊卡片
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
export declare const chattingSendCard: (requestInfo: IRequestInfo) => Promise<unknown>;
/**
 * 文本风险校验
 * @param {string} text 文本
 */
export declare const textRiskIdentification: (text: string) => Promise<unknown>;
/**
 * 跳转店铺首页
 * @param {string} shopId
 */
export declare const navigateToTaobaoPage: (shopId: string) => Promise<unknown>;
