"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var tb_1 = require("../core/tb");
var tbFn_1 = require("../core/tbFn");
var utils_1 = require("../utils");
// 通用API封装方法
var capiFn = function (apiList, request) {
    return {
        receiveObjectPrize: function (params) {
            return __awaiter(this, void 0, void 0, function () {
                var _a, handle, method, ext, userAddress, _b, name, telNumber, provinceName, cityName, cityCode, countyName, detailInfo, streetName, confirmResult, _c;
                return __generator(this, function (_d) {
                    switch (_d.label) {
                        case 0:
                            _a = utils_1.getRequestParams(apiList['receiveObjectPrize']), handle = _a.handle, method = _a.method, ext = _a.ext;
                            return [4 /*yield*/, tbFn_1.getUserAddress().catch(function (err) {
                                    tb_1.commonToast(err.errorMessage);
                                })];
                        case 1:
                            userAddress = _d.sent();
                            _b = userAddress || {}, name = _b.name, telNumber = _b.telNumber, provinceName = _b.provinceName, cityName = _b.cityName, cityCode = _b.cityCode, countyName = _b.countyName, detailInfo = _b.detailInfo, streetName = _b.streetName;
                            params = __assign({ name: name, phone: telNumber, addressDetail: detailInfo, cityCode: cityCode, city: cityName, province: provinceName, area: countyName, streetName: streetName }, params);
                            if (!userAddress) return [3 /*break*/, 3];
                            return [4 /*yield*/, tb_1.commonConfirm('提示', '确认使用该收货地址：' + name + telNumber + userAddress.duibaAddress.address, function () {
                                    return __awaiter(this, void 0, void 0, function () {
                                        var result;
                                        return __generator(this, function (_a) {
                                            switch (_a.label) {
                                                case 0: return [4 /*yield*/, request(handle, method, params, ext).catch(function (res) {
                                                        tb_1.commonToast(res && res.message);
                                                    })];
                                                case 1:
                                                    result = _a.sent();
                                                    if (result && result.success) {
                                                        return [2 /*return*/, true];
                                                    }
                                                    return [2 /*return*/, false];
                                            }
                                        });
                                    });
                                })];
                        case 2:
                            _c = (_d.sent());
                            return [3 /*break*/, 4];
                        case 3:
                            _c = false;
                            _d.label = 4;
                        case 4:
                            confirmResult = _c;
                            return [2 /*return*/, confirmResult];
                    }
                });
            });
        },
        getVipInfo: function (params) {
            return __awaiter(this, void 0, void 0, function () {
                var _a, handle, method, ext, result, isVip;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = utils_1.getRequestParams(apiList['getVipInfo']), handle = _a.handle, method = _a.method, ext = _a.ext;
                            return [4 /*yield*/, request(handle, method, params, ext).catch(function (res) {
                                    tb_1.commonToast(res && res.message);
                                })];
                        case 1:
                            result = _b.sent();
                            if (result && result.success) {
                                isVip = result.data.isVip;
                                return [2 /*return*/, isVip];
                            }
                            return [2 /*return*/, false];
                    }
                });
            });
        },
        receiveEnamePrize: function (params) {
            return __awaiter(this, void 0, void 0, function () {
                var _a, handle, method, ext, result;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = utils_1.getRequestParams(apiList['receiveEnamePrize']), handle = _a.handle, method = _a.method, ext = _a.ext;
                            return [4 /*yield*/, request(handle, method, params, ext).catch(function (res) {
                                    tb_1.commonToast(res && res.message);
                                })];
                        case 1:
                            result = _b.sent();
                            if (result && result.success) {
                                return [2 /*return*/, true];
                            }
                            return [2 /*return*/, false];
                    }
                });
            });
        },
        addStat: function (activityId, type) {
            return __awaiter(this, void 0, void 0, function () {
                var _a, handle, method, ext, result;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = utils_1.getRequestParams(apiList['addStat']), handle = _a.handle, method = _a.method, ext = _a.ext;
                            return [4 /*yield*/, request(handle, method, {
                                    activityId: activityId,
                                    type: type
                                }, ext).catch(function (res) {
                                    tb_1.commonToast(res && res.message);
                                })];
                        case 1:
                            result = _b.sent();
                            if (result && result.success) {
                                return [2 /*return*/, true];
                            }
                            return [2 /*return*/, false];
                    }
                });
            });
        },
    };
};
exports.default = capiFn;
//# sourceMappingURL=capiFn.js.map