import { getAuthUserInfo } from '../core/tbFn';
import { commonConfirm } from '../core/tb'
import { myRequest } from './index'
const Buffer = require("buffer").Buffer
const crypto = require("crypto")
/**
 * 加密
 * @param data 
 */
export const md5 = (data: any) => {
    var buf = new Buffer(data);
    var str = buf.toString("binary");
    return crypto.createHash("md5").update(str).digest("hex").slice(0, 30);
}
/**
 * my.request请求接口
 * @param params 
 * @param res 
 * @param loading 
 * @param tornadoAPI 
 */
export const tornadoAPICb = async (params: any, res: any, loading: boolean, tornadoAPI: string) => {
    const { nickName } = res
    params.openId = md5(nickName)
    const params_ = {
        url: tornadoAPI,
        method: 'post',
        data: params,
        dataType: 'json'
    }
    return await myRequest(params_, loading)
}
/**
 * 请求风池台接口数据
 * @param tornadoAPI 
 * @param nickName 
 * @param handle 
 * @param loading 
 * @param params 
 */
export const tornadoAPIFn = async (tornadoAPI: string, nickName: string, handle: string, loading: boolean, params: any) => {
    // 处理涉及的三个参数
    let matchRes = tornadoAPI.match(/db=(\w*)&proxyIp=([\d]{1,3}\.[\d]{1,3}\.[\d]{1,3}\.[\d]{1,3})/)
    let db = matchRes[1]
    let proxyIp = matchRes[2]
    let data_ = {
      handler: handle,
      data: params
    }
    console.log(`data_`, data_)
    let params_ = {
      db,
      proxyIp,
      data: data_
    }
    if (!db || !proxyIp) {
        commonConfirm('风驰台地址错误','请确认风驰台的地址是否正确，未查找到db和proxyIp')
        return false
    }
    // nickName 转 md5 作为唯一的openId
    if (!nickName) {
        return getAuthUserInfo().catch(err => {
            console.log('未授权成功', err);
        }).then(res=> {
            return tornadoAPICb(params_, res, loading, tornadoAPI)
        })
    }
}
/**
 * 请求mock数据
 * @param reqConfig 
 * @param initConfig 
 * @param params 
 */
export const requestMock = async (reqConfig: IReqConfig, initConfig: IInitConfig, params: any) => {
    const { cloudName, handle, method, isShowLoading } = reqConfig
    const { requestType, tornadoAPI, nickName, mockUrlPrefix, mockUrl } = initConfig
    // 若请求的是风驰台的api
    if (requestType === 'tornadoAPI') {
        return await tornadoAPIFn(tornadoAPI, nickName, handle, isShowLoading, params)
    }
    const requestPrefix = mockUrl || mockUrlPrefix[requestType];
    const params_ = {
        url: requestPrefix + cloudName + '.' + handle,
        method: 'get',
        data: params,
        dataType: 'json'
    }
    return await myRequest(params_, isShowLoading)
}