import { requestMock } from '../helpers/requestFn';
import { cloudRequest } from '../helpers';
/**
 * 接口请求封装
 * @param { cloud, cloudName, requestType, mockUrl } 
 */
const request = (header:IRequest) => {
    const { cloud, cloudName, requestType = 'cloud', mockUrl } = header
    if (!cloud) {
        console.error('请传入cloud');
        return false;
    }
    if (!cloudName) {
        console.error('请传入云函数名称');
        return false;
    }

    return async (handle, method = 'POST', params, ext?: { cloudName?: string, isShowLoading?: boolean, toastError?: boolean }) => {
        // @ts-ignore
        const { activityId, tornadoAPI, nickName = '' } = getApp();
        const _cloudName = ext.cloudName || cloudName;
        const { isShowLoading = false, toastError = true } = ext;
        const mockUrlPrefix = {
            ams: 'https://ams.dui88.com/server/index.php?g=Web&c=Mock&o=simple&projectID=218&uri=',
            yapi: 'https://docs.dui88.com/mock/140/'
        };
        const reqConfig = { cloudName: _cloudName, handle, method, isShowLoading }
        const initConfig = { requestType, tornadoAPI, nickName, mockUrlPrefix, mockUrl }
        const params_ = { activityId, ...params }

        if (['ams', 'yapi', 'tornadoAPI'].includes(requestType)) return await requestMock(reqConfig, initConfig, params_);
        

        return await cloudRequest(cloud, _cloudName, handle, params_, isShowLoading, toastError);
    }
}
export default request