"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.navigateToTaobaoPage = exports.textRiskIdentification = exports.chattingSendCard = exports.cloudTBIssue = exports.getUserStatus = exports.getAuthUserInfo = exports.uploadImage = exports.chooseImage = exports.getUserAddress = void 0;
var helpers_1 = require("../helpers");
/**
 * 获取淘宝用户收货地址
 */
var getUserAddress = function (opts) {
    if (opts === void 0) { opts = {}; }
    return __awaiter(void 0, void 0, void 0, function () {
        var defaults, _opts;
        return __generator(this, function (_a) {
            defaults = {
                addAddress: 'show',
                searchAddress: 'hide',
                locateAddress: 'hide',
                joinTag: '' // 分割收货地址符号（淘宝商家有特定发货需求）
            };
            _opts = Object.assign({}, defaults, opts);
            return [2 /*return*/, new Promise(function (resolve, reject) {
                    // @ts-ignore
                    my.authorize({
                        scopes: 'scope.addressList',
                        success: function () {
                            var addAddress = _opts.addAddress, searchAddress = _opts.searchAddress, locateAddress = _opts.locateAddress, joinTag = _opts.joinTag;
                            // @ts-ignore
                            if (!my.tb.chooseAddress) {
                                reject({
                                    noSupport: true,
                                    errorMessage: '当前版本不支持选择收货地址，请升级到最新版本'
                                });
                                return false;
                            }
                            // @ts-ignore
                            my.tb.chooseAddress({
                                addAddress: addAddress,
                                searchAddress: searchAddress,
                                locateAddress: locateAddress
                            }, function (res) {
                                var error = res.error, provinceName = res.provinceName, countyName = res.countyName, cityName = res.cityName, streetName = res.streetName, detailInfo = res.detailInfo, name = res.name, telNumber = res.telNumber;
                                // 如果有error为用户取消操作不做操作
                                if (error) {
                                    resolve(false);
                                }
                                else {
                                    resolve(__assign(__assign({}, res), { duibaAddress: {
                                            name: name,
                                            phone: telNumber,
                                            address: [provinceName, cityName, countyName, streetName, detailInfo].join(joinTag)
                                        } }));
                                }
                            }, function (res) {
                                reject(res);
                            });
                        },
                        fail: function (err) {
                            reject(err);
                        }
                    });
                })];
        });
    });
};
exports.getUserAddress = getUserAddress;
/**
 * 选择图片
 * @param opts
 */
var chooseImage = function (opts) {
    if (opts === void 0) { opts = {}; }
    return __awaiter(void 0, void 0, void 0, function () {
        var defaults, _opts, count, sourceType, compressLevel;
        return __generator(this, function (_a) {
            defaults = {
                count: 1,
                sourceType: ['camera', 'album'],
                compressLevel: 1
            };
            _opts = Object.assign({}, defaults, opts);
            count = _opts.count, sourceType = _opts.sourceType, compressLevel = _opts.compressLevel;
            return [2 /*return*/, new Promise(function (resolve, reject) {
                    // @ts-ignore
                    if (!my.chooseImage) {
                        reject({
                            noSupport: true,
                            errorMessage: '当前版本不支持选择图片，请升级到最新版本'
                        });
                        return false;
                    }
                    // @ts-ignore
                    my.chooseImage({
                        count: count,
                        sourceType: sourceType,
                        success: function (res) {
                            // @ts-ignore
                            my.compressImage({
                                apFilePaths: res.apFilePaths,
                                level: compressLevel,
                                success: function (data) {
                                    resolve(data);
                                },
                                fail: function (err) {
                                    resolve(err);
                                }
                            });
                        },
                        fail: function (err) {
                            // error code 2001 为摄像头授权取消、ios 11为用户取消操作不认作失败场景 、安卓 为1
                            if (err.error !== 2001 && err.error !== 11 && err.error !== 1) {
                                reject(err);
                            }
                            else {
                                resolve(false);
                            }
                        }
                    });
                })];
        });
    });
};
exports.chooseImage = chooseImage;
/**
 * 获取图片信息
 * @param {*} opts chooseImage配置参数
 */
var uploadImage = function (opts) {
    if (opts === void 0) { opts = {}; }
    return __awaiter(void 0, void 0, void 0, function () {
        var cloud, chooseImageResult, apFilePaths, filePath, imageInfo, imagePath, url;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    cloud = getApp().cloud;
                    if (!cloud) {
                        console.error('chattingSendCard: 请传入app.cloud');
                        return [2 /*return*/, false];
                    }
                    return [4 /*yield*/, exports.chooseImage(opts).catch(function (err) {
                            console.error('选择图片失败');
                        })];
                case 1:
                    chooseImageResult = _a.sent();
                    if (!chooseImageResult) return [3 /*break*/, 4];
                    apFilePaths = chooseImageResult.apFilePaths;
                    filePath = apFilePaths[0];
                    return [4 /*yield*/, helpers_1.promisifyApi('getImageInfo', { src: filePath })
                        // 找不到图片信息
                    ];
                case 2:
                    imageInfo = _a.sent();
                    // 找不到图片信息
                    if (!imageInfo) {
                        return [2 /*return*/, false];
                    }
                    imagePath = imageInfo.path;
                    return [4 /*yield*/, cloud.file.uploadFile({
                            filePath: filePath,
                            fileType: 'image',
                            fileName: imagePath.split('/').pop()
                        })];
                case 3:
                    url = (_a.sent()).url;
                    return [2 /*return*/, url];
                case 4: return [2 /*return*/, false];
            }
        });
    });
};
exports.uploadImage = uploadImage;
/**
 * 获取授权用户信息
 * @returns {object} 用户登录信息
 */
var getAuthUserInfo = function () {
    return new Promise(function (resolve, reject) {
        // @ts-ignore
        my.authorize({
            scopes: 'scope.userInfo',
            success: function () {
                // @ts-ignore
                my.getAuthUserInfo({
                    success: function (userInfo) {
                        resolve(userInfo);
                    },
                    fail: function (err) {
                        reject(err);
                    }
                });
            },
            fail: function (err) {
                reject(err);
            }
        });
    });
};
exports.getAuthUserInfo = getAuthUserInfo;
/**
 * 获取用户会员状态(Tmall使用)
 */
var getUserStatus = function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, new Promise(function (resolve, reject) {
                // @ts-ignore
                my.authorize({
                    scopes: "scope.campus.audit",
                    success: function () { return __awaiter(void 0, void 0, void 0, function () {
                        var result;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, helpers_1.getTmallMemberStatus()];
                                case 1:
                                    result = _a.sent();
                                    resolve(result.result);
                                    return [2 /*return*/];
                            }
                        });
                    }); },
                    fail: function (err) {
                        console.log(err);
                        reject(err);
                    },
                });
            })];
    });
}); };
exports.getUserStatus = getUserStatus;
/**
 * 拉菲奖品发放(Tmall使用)
 * @param params
 */
var cloudTBIssue = function (params) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, new Promise(function (resolve, reject) {
                // @ts-ignore
                my.authorize({
                    scopes: "scope.latourBenefit",
                    success: function () { return __awaiter(void 0, void 0, void 0, function () {
                        var result;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, helpers_1.strategyEname(params)];
                                case 1:
                                    result = _a.sent();
                                    console.log(result, "result");
                                    resolve(result);
                                    return [2 /*return*/];
                            }
                        });
                    }); },
                    fail: function (err) {
                        console.log(err);
                        reject(err);
                    },
                });
            })];
    });
}); };
exports.cloudTBIssue = cloudTBIssue;
/**
 * 分享到群聊卡片
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
var chattingSendCard = function (requestInfo) { return __awaiter(void 0, void 0, void 0, function () {
    var cloud;
    return __generator(this, function (_a) {
        cloud = getApp().cloud;
        if (!cloud) {
            console.error('chattingSendCard: 请传入app.cloud');
            return [2 /*return*/, false];
        }
        if (!requestInfo) {
            console.error('chattingSendCard: 请传入卡片请求参数');
            return [2 /*return*/, false];
        }
        return [2 /*return*/, new Promise(function (resolve, reject) {
                // @ts-ignore
                my.authorize({
                    scopes: 'scope.groupChat',
                    success: function () { return __awaiter(void 0, void 0, void 0, function () {
                        var result, error;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, cloud.topApi
                                        .invoke({
                                        api: 'taobao.chatting.platform.message.sendcard',
                                        data: { request_info: JSON.stringify(requestInfo) }
                                    })
                                        .catch(function (err) {
                                        reject(err);
                                    })];
                                case 1:
                                    result = _a.sent();
                                    if (result) {
                                        error = result.error;
                                        if (error) {
                                            resolve(false);
                                        }
                                        else {
                                            resolve(result);
                                        }
                                    }
                                    return [2 /*return*/];
                            }
                        });
                    }); },
                    fail: function (err) {
                        if (err.error === 11) {
                            // error code 11 为用户取消操作不认作失败场景
                            resolve(false);
                        }
                        reject(err);
                    }
                });
            })];
    });
}); };
exports.chattingSendCard = chattingSendCard;
/**
 * 文本风险校验
 * @param {string} text 文本
 */
var textRiskIdentification = function (text) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, new Promise(function (resolve, reject) {
                // @ts-ignore
                if (!my.tb.textRiskIdentification) {
                    reject({
                        noSupport: true,
                        errorMessage: '不支持文本校验'
                    });
                }
                // @ts-ignore
                my.tb.textRiskIdentification({
                    data: {
                        text: text
                    },
                    success: function (res) {
                        if (res.data && res.data.result) {
                            var suggestion = res.data.result.suggestion;
                            if (suggestion === 'pass') {
                                resolve(true);
                            }
                        }
                        resolve(false);
                    },
                    fail: function (err) {
                        reject(err);
                    },
                });
            })];
    });
}); };
exports.textRiskIdentification = textRiskIdentification;
/**
 * 跳转店铺首页
 * @param {string} shopId
 */
var navigateToTaobaoPage = function (shopId) {
    return new Promise(function (resolve, reject) {
        // @ts-ignore
        my.tb.navigateToTaobaoPage({
            appCode: 'shop',
            appParams: {
                shopId: String(shopId),
                weexShopTab: "shopindexbar",
                weexShopSubTab: "shopindex"
            },
            success: function (res) {
                resolve(true);
            },
            fail: function (res) {
                reject(res.error);
            }
        });
    });
};
exports.navigateToTaobaoPage = navigateToTaobaoPage;
//# sourceMappingURL=tbFn.js.map