/** @format */

interface IParamJSAPI {
    title?: string
    content?: string
    duration?: number
    success?: (t?: any) => any
    url?: string
    delta?: number
    confirmButtonText?: string
    cancelButtonText?: string
}

interface IAddress {
    name?: string
    telNumber?: string
    provinceName?: string
    cityName?: string 
    cityCode?:string 
    countyName?: string 
    detailInfo?: string 
    streetName?: string
    duibaAddress?: ISubAddress
}

interface ISubAddress {
    address: string
}

interface IRequest {
    cloud: string
    cloudName: string
    requestType?: string
    mockUrl?: string
}

interface IReqConfig {
    cloudName: string 
    handle: string 
    method: string 
    isShowLoading: boolean
}

interface IInitConfig {
    requestType: string
    tornadoAPI: string 
    nickName: string 
    mockUrlPrefix: IMockUrlPrefix
    mockUrl: string
}

interface IMockUrlPrefix {
    ams: string
    yapi: string
}

interface IRequestInfo {
    group_id: string
    weex_data_json: string
    message_id: string
    card_template_id: string
    app_secret: string
    biz_ext_map?: string
    app_code?: string
    wx_display_name?: string
    wx_display_type?: string
    target_open_id?: string
    at_open_id?: string
    target_user_nick?: string
    at_user_nick?: string
}

interface ISkuInfo {
    status: string
    itemId: string
    skuId: string
    quantity: string
}

declare var my: any