import { commonToast, commonConfirm } from '../core/tb';
import { getUserAddress } from '../core/tbFn';
import { getRequestParams } from '../utils';

// 通用API封装方法
const capiFn = (apiList, request) => {
  return {
    async receiveObjectPrize(params,failMessage,successMessage) {
      const { handle, method, ext } = getRequestParams(apiList['receiveObjectPrize']);
      const userAddress: IAddress = await getUserAddress().catch(err => {
        commonToast(err.errorMessage);
      });
      if(!userAddress) return false
      const { name, telNumber, provinceName, cityName, cityCode, countyName, detailInfo, streetName } = userAddress || {};
      params = {
        name,
        phone: telNumber,
        addressDetail: detailInfo,
        cityCode,
        city: cityName,
        province: provinceName,
        area: countyName,
        streetName,
        ...params
      }
      await commonConfirm('提示', '确认使用该收货地址：' + name + telNumber + userAddress.duibaAddress.address, async function() {
        const result = await request(handle, method, params, ext).catch(res => {
          commonToast(res && res.message);
        });
        if (result && !result.success) {
          commonToast(failMessage || '领取失败，前去“我的奖品”查看原因');
          return true;
        }
        if (result && result.success) {
          successMessage && commonToast(successMessage)
          return true;
        }
      })
      return false
    },

    async getVipInfo(params) { 
      const { handle, method, ext } = getRequestParams(apiList['getVipInfo']);
      const result = await request(handle, method, params, ext).catch(res => {
        commonToast(res && res.message);
      });
      if (result && result.success) {
        const { isVip } = result.data
        return isVip;
      }
      return false;
    },

    async receiveEnamePrize(params,failMessage,successMessage) {
      const { handle, method, ext } = getRequestParams(apiList['receiveEnamePrize']);
      const result = await request(handle, method, params, ext).catch(res => {
        commonToast(res && res.message);
      });
      if (result && !result.success) {
        commonToast(failMessage || '领取失败，前去“我的奖品”查看原因');
        return true;
      }
      if (result && result.success) {
        successMessage && commonToast(successMessage)
        return true;
      }
      return false;
    },

    async addStat(type: number | string, param = {}) {
      const { handle, method, ext } = getRequestParams(apiList['addStat']);
      const result = await request(handle, method, {
        type,
        ...param
      }, ext).catch(res => {
        commonToast(res && res.message);
      });
      if (result && result.success) {
        return true;
      }
      return false;
    },
  }
};

export default capiFn;
