import { commonToast } from '../core/tb';
import { getUserAddress } from '../core/tbFn';
import { applyActivity } from '../utils';

// 领取实物
const getUerAddressParam = async () => {
  const userAddress: any = await getUserAddress().catch(err => {
      commonToast(err.errorMessage);
  });
  if(!userAddress) return false
  const { name, telNumber, provinceName, cityName, cityCode, countyName, detailInfo, streetName } = userAddress || {};
  const params = {
      name,
      phone: telNumber,
      addressDetail: detailInfo,
      cityCode,
      city: cityName,
      province: provinceName,
      area: countyName,
      streetName,
  }
  return {
      params,
      duibaAddress: userAddress.duibaAddress.address
  }
}
const confirmAddress = async (address) => {
  return new Promise(async (resolve,reject) => {
    // @ts-ignore
      my.confirm({
          title: '提示',
          content: '确认使用该收货地址：' + address,
          success: (res) => {
              if(res.confirm) {
                  resolve(true)
              }else {
                  resolve(false)
              }
          },
      });
  })
}
/**
 * 领取实物奖品
 * @param api 
 * @param data 
 */
export const receiveObjectPrize = async (api: any, data: IReceivePrize) => {
  const { params, successMsg, errorMsg } = data
  return new Promise(async (resolve,reject) => {
      const userInfo = await getUerAddressParam()
      if(!userInfo) {
          resolve(false)
          return;
      }
      const { params: _params, duibaAddress } = userInfo
      const { name, phone } = _params
      const address = name + phone + duibaAddress
      const canPass = await confirmAddress(address)
      if(!canPass) {
          resolve(false)
          return;
      }
      const { success, data, message } = await api({ ...params, ..._params })
      if (success) {
          commonToast(successMsg)
          resolve(true)
      }else {
          commonToast(errorMsg || message)
          resolve(false)
      }
  })
}
/**
 * 领取权益
 * @param api 
 * @param data 
 */
export const receiveEnamePrize = async (api: any, data: IReceivePrize) => {
  const { params, successMsg, errorMsg } = data
  return new Promise(async (resolve,reject) => {
      const { success, data, message } = await api(params).catch(res => {
          commonToast(successMsg || res.message)
          resolve(false)
      });
      if (success) {
          commonToast(successMsg)
          resolve(true)
      }else {
          commonToast(errorMsg || message)
          resolve(false)
      }
  })
}
/**
 * 会员优惠券领取
 * @param api 
 * @param data 
 */
export const receiveMemberEname = async(api: any, data: IReceivePrize) => {
  const { params, successMsg, errorMsg } = data
  const { sellerId, ename, ...ext } = params
  if(!ename) return false
  return new Promise(async (resolve,reject) => {
      const result: any = await applyActivity({sellerId, activityId: ename })
      if(!result) resolve(false)
      if(result.businessSuccess) {
          const { success, data, message } = await api({ ...ext })
          if(success) {
              commonToast(successMsg || '奖品发放成功，请前往我的奖品处进行使用')
              resolve(true)
          }else {
              commonToast(errorMsg || message)
              resolve(false)
          }
      }else{
          commonToast(result.errorMsg)
          resolve(false)
      }
  })
}