"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGrade = exports.applyActivity = exports.getActivity = exports.validateActivityStatus = exports.formatTimeStamp = exports.checkIsMember = exports.getImgShareUrl = exports.throttleHandle = exports.generateAPI = exports.getRequestParams = exports.versionCompare = exports.dateFormatter = void 0;
var tb_1 = require("../core/tb");
/**
 * 时间格式化
 * @param date    接收可以被new Date()方法转换的内容
 * @param format  字符串，需要的格式例如：'yyyy/MM/dd hh:mm:ss'
 * @returns {String}
 */
var dateFormatter = function (dateTxt, format) {
    if (format === void 0) { format = 'yyyy/MM/dd'; }
    if (!dateTxt)
        return '-';
    var date = new Date(typeof dateTxt === 'string' && isNaN(+dateTxt) ? dateTxt.replace(/-/g, '/') : dateTxt);
    var o = {
        'M+': date.getMonth() + 1,
        'd+': date.getDate(),
        'h+': date.getHours(),
        'm+': date.getMinutes(),
        's+': date.getSeconds(),
        'q+': Math.floor((date.getMonth() + 3) / 3),
        S: date.getMilliseconds()
    };
    if (/(y+)/.test(format)) {
        format = format.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length));
    }
    for (var k in o) {
        if (new RegExp('(' + k + ')').test(format)) {
            format = format.replace(RegExp.$1, RegExp.$1.length === 1 ? o[k] : ('00' + o[k]).substr(('' + o[k]).length));
        }
    }
    return format;
};
exports.dateFormatter = dateFormatter;
/**
 * 版本比较
 * @param {string} cur 当前版本
 * @param {string} compare 比较版本
 */
var versionCompare = function (cur, compare) {
    var _cur = cur.split('.');
    var _compare = compare.split('.');
    if (+_cur[0] < +_compare[0]) {
        return false;
    }
    else if (+_cur[0] === +_compare[0] && +_cur[1] < +_compare[1]) {
        return false;
    }
    else if (+_cur[0] === +_compare[0] && +_cur[1] === +_compare[1] && +_cur[2] < +_compare[2]) {
        return false;
    }
    return true;
};
exports.versionCompare = versionCompare;
/**
 * 获取request请求所需参数
 * @param {object/string} value API项配置
 */
var getRequestParams = function (value) {
    if (typeof value === 'string') {
        return {
            handle: value,
            method: 'POST',
            ext: {}
        };
    }
    else if (typeof value === 'object') {
        var handle = value.handle, _a = value.method, method = _a === void 0 ? 'POST' : _a, _b = value.defaultParams, defaultParams = _b === void 0 ? {} : _b, ext = __rest(value, ["handle", "method", "defaultParams"]);
        return {
            handle: handle,
            method: method,
            defaultParams: defaultParams,
            ext: __assign({}, ext)
        };
    }
    else {
        console.error('getRequestParams: 传参有误');
    }
};
exports.getRequestParams = getRequestParams;
/**
 * 生成API
 * @param {array} apiList API数据数组
 * @param {function} request 请求
 */
var generateAPI = function (apiList, request) {
    // @ts-ignore
    var api = {};
    Object.entries(apiList).forEach(function (_a) {
        var key = _a[0], value = _a[1];
        var _b = exports.getRequestParams(value), handle = _b.handle, method = _b.method, ext = _b.ext, defaultParams = _b.defaultParams;
        api[key] = function (params, config) {
            if (config === void 0) { config = {}; }
            return request(handle, method, Object.assign({}, defaultParams, params), Object.assign({}, ext, config));
        };
    });
    return api;
};
exports.generateAPI = generateAPI;
/**
 * 函数节流，普通防连点
 * @param {fun} fun 函数
 * @param {delay} delay 时间
 */
var throttleHandle = function (fun, delay) {
    if (delay === void 0) { delay = 1000; }
    var last, deferTimer;
    return function () {
        var now = +new Date();
        if (last && now < last + delay) {
            clearTimeout(deferTimer);
            deferTimer = setTimeout(function () {
                last = now;
            }, delay);
        }
        else {
            last = now;
            fun.apply(this, arguments);
        }
    };
};
exports.throttleHandle = throttleHandle;
/**
 * 根据fileId获取图片地址
 * @param fileId
 */
var getImgShareUrl = function (fileId) { return __awaiter(void 0, void 0, void 0, function () {
    var cloud, list;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                cloud = getApp().cloud;
                return [4 /*yield*/, cloud.file.getTempFileURL({ fileId: fileId })];
            case 1:
                list = _a.sent();
                if (typeof fileId === 'string')
                    return [2 /*return*/, list && list[0].url];
                return [2 /*return*/, list];
        }
    });
}); };
exports.getImgShareUrl = getImgShareUrl;
/**
 * 根据sellerId判断入会状态
 * @param sellerId
 */
var checkIsMember = function (sellerId) { return __awaiter(void 0, void 0, void 0, function () {
    var memberPlugin;
    return __generator(this, function (_a) {
        memberPlugin = requirePlugin("cemMember");
        if (!memberPlugin) {
            console.log('会员检查失败 :>> 请先申请入会插件');
            return [2 /*return*/, false];
        }
        return [2 /*return*/, new Promise(function (resolve, reject) {
                memberPlugin.checkMember({
                    sellerId: sellerId,
                    success: function (res) {
                        var _a;
                        console.log('会员检查成功 :>> ', res);
                        var isMember = (res === null || res === void 0 ? void 0 : res.businessSuccess) && ((_a = res === null || res === void 0 ? void 0 : res.data) === null || _a === void 0 ? void 0 : _a.isMember) === 'true';
                        resolve(isMember);
                    },
                    fail: function (res) {
                        console.log('会员检查失败 :>> ', res);
                        console.warn('checkMember 需在真机上调试');
                        reject(res);
                    }
                });
            })];
    });
}); };
exports.checkIsMember = checkIsMember;
/**
 * 毫秒转换成00:00:00格式
 * @param ms 毫秒
 */
var formatTimeStamp = function (ms) {
    var hours = parseInt(String(ms / (1000 * 60 * 60))), minutes = parseInt(String((ms % (1000 * 60 * 60)) / (1000 * 60))), seconds = parseInt(String((ms % (1000 * 60)) / 1000));
    hours = hours < 10 ? '0' + hours : hours;
    minutes = minutes < 10 ? '0' + minutes : minutes;
    seconds = seconds < 10 ? '0' + seconds : seconds;
    return hours + ":" + minutes + ":" + seconds;
};
exports.formatTimeStamp = formatTimeStamp;
/**
 * 活动状态验证
 * @param startTime
 * @param endTime
 * @param noCheck
 */
var validateActivityStatus = function (checkParam) { return __awaiter(void 0, void 0, void 0, function () {
    var nowTime, startTime, endTime, noCheck;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, tb_1.getServerTime()];
            case 1:
                nowTime = _a.sent();
                startTime = checkParam.startTime, endTime = checkParam.endTime, noCheck = checkParam.noCheck;
                if (!startTime || !endTime)
                    return [2 /*return*/, false];
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        if (nowTime < startTime) {
                            tb_1.commonToast('活动未开始');
                            resolve(false);
                        }
                        else if (nowTime > endTime && !noCheck) {
                            tb_1.commonToast('活动已结束');
                            resolve(false);
                        }
                        else {
                            resolve(true);
                        }
                    })];
        }
    });
}); };
exports.validateActivityStatus = validateActivityStatus;
/**
 * 查询商家权益活动
 * @param sellerId
 */
var getActivity = function (sellerId) {
    // @ts-ignore
    var memberBenefitPlugin = requirePlugin("memberBenefit");
    if (!memberBenefitPlugin)
        return [];
    return new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            memberBenefitPlugin.getActivity({
                data: {
                    sellerId: sellerId,
                },
                success: function (result) {
                    resolve(result);
                },
                fail: function (error) {
                    console.log('获取失败' + JSON.stringify(error));
                    resolve(error);
                }
            });
            return [2 /*return*/];
        });
    }); });
};
exports.getActivity = getActivity;
/**
 * 领取会员优惠券
 * @param params
 */
var applyActivity = function (params) {
    var sellerId = params.sellerId, activityId = params.activityId;
    // @ts-ignore
    var memberBenefitPlugin = requirePlugin("memberBenefit");
    if (!memberBenefitPlugin)
        return false;
    return new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            memberBenefitPlugin.applyActivity({
                data: {
                    sellerId: sellerId,
                    activityId: activityId,
                },
                success: function (result) {
                    resolve(result);
                },
                fail: function (error) {
                    console.warn('领取商家权益失败' + JSON.stringify(error.data));
                    resolve(error.data);
                }
            });
            return [2 /*return*/];
        });
    }); });
};
exports.applyActivity = applyActivity;
// 查询商家会员等级
var getGrade = function (sellerId) {
    // @ts-ignore
    var memberBenefitPlugin = requirePlugin("memberBenefit");
    if (!memberBenefitPlugin)
        return [];
    return new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            memberBenefitPlugin.getGrade({
                data: {
                    sellerId: sellerId
                },
                success: function (result) {
                    resolve(result);
                },
                fail: function (error) {
                    console.log('查询商家会员等级失败' + JSON.stringify(error));
                    resolve(error);
                }
            });
            return [2 /*return*/];
        });
    }); });
};
exports.getGrade = getGrade;
//# sourceMappingURL=index.js.map