import * as utils from './utils';
import * as constants from './constants';
import * as capiFn from './request/capiFn';
declare const _default: {
    capi: {
        getMyAwardsList: {
            method: string;
            handle: string;
            isShowLoading: boolean;
        };
        receiveObjectPrize: {
            method: string;
            handle: string;
        };
        receiveEnamePrize: {
            method: string;
            handle: string;
        };
        completeTask: {
            method: string;
            handle: string;
        };
        receiveTask: {
            method: string;
            handle: string;
        };
        getTaskList: {
            method: string;
            handle: string;
        };
        getCollectGoods: {
            method: string;
            handle: string;
        };
    };
    capiFn: typeof capiFn;
    tb: {
        getUserAddress: (opts?: {}) => Promise<unknown>;
        chooseImage: (opts?: {}) => Promise<unknown>;
        uploadImage: (opts?: {}) => Promise<any>;
        getAuthUserInfo: () => Promise<unknown>;
        getUserStatus: () => Promise<unknown>;
        cloudTBIssue: (params: {
            channel: string;
            strategyCode: string;
            code: string;
        }) => Promise<unknown>;
        chattingSendCard: (requestInfo: IRequestInfo) => Promise<unknown>;
        textRiskIdentification: (text: string) => Promise<unknown>;
        navigateToTaobaoPage: (shopId: string) => Promise<unknown>;
        commonToast: (content: string, duration?: number, successCb?: () => any) => void;
        simpleAlert: (content: string) => void;
        commonConfirm: (title: string, content: string, successCb?: () => any) => Promise<void>;
        getSystemInfo: () => Promise<unknown>;
        favorShop: (sellerId: number) => Promise<boolean | {
            error?: number;
        }>;
        checkShopFavoredStatus: (sellerId: number) => Promise<boolean | {
            isFavor?: boolean;
        }>;
        navigateToOutside: (url: any) => boolean;
        navigateTo: (url: any) => boolean;
        navigateBack: (delta?: number) => void;
        redirectTo: (url: string) => boolean;
        getServerTime: () => Promise<string | {
            time?: string;
        }>;
        collectGoods: (id: number) => Promise<false | {
            error?: number;
        }>;
        checkGoodsCollectedStatus: (id: number) => Promise<boolean | {
            isCollect?: boolean;
        }>;
        openDetail: (itemId: string) => Promise<unknown>;
        createAudio: (opts: {
            src: string;
            autoplay?: boolean;
        }) => import("./helpers").AudioModel;
        getImageInfo: (src: string) => Promise<unknown>;
        setClipboard: (text: string) => Promise<unknown>;
        showSharePanel: () => Promise<void>;
        hideShareMenu: () => Promise<void>;
        getStorage: (key: string) => Promise<string>;
        setStorage: (key: string, value: any) => Promise<unknown>;
        removeStorage: (key: string) => Promise<unknown>;
        taobaoReportClick: (eventType: string, logkey: string) => void;
        openMessage: (sellerNick: string, itemId: string) => Promise<unknown>;
        showSkuModal: (itemId: string) => Promise<unknown>;
        hideSkuModal: () => Promise<unknown>;
        confirmCustomOrder: (itemId: number, skuId?: number, quantity?: number) => Promise<unknown>;
    };
    utils: typeof utils;
    request: (header: IRequest) => false | ((handle: any, method: string, params: any, ext?: {
        cloudName?: string;
        isShowLoading?: boolean;
        toastError?: boolean;
    }) => Promise<unknown>);
    constants: typeof constants;
};
export default _default;
