import { 
    promisifyApiSimple, 
    promisifyApi, 
    promisifyApiToTb, 
    AudioModel
} from '../helpers'
/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
export const commonToast = (content: string, duration?: number, successCb?: () => any) => {
    promisifyApiSimple('showToast',{
        content: content || '换个姿势再试一次~',
        duration: duration || 3000,
        success: successCb
    })
};
/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
export const showToast = (params: { content: string, duration?: number, success?: () => any }, Taro?: any) => {
    const { content, duration, success } = params
    promisifyApiSimple('showToast',{
        [Taro?'title':'content']: content || '换个姿势再试一次~',
        duration: duration || 3000,
        success: success
    },null,Taro)
};
/**
 * 简易alert
 * @param {string} content toast内容
 */
export const simpleAlert = (content: string, Taro?: any) => {
    promisifyApiSimple('alert',{
        content
    },null,Taro)
};
/**
 * 通用确认弹窗
 * @param {string} title 标题
 * @param {string} content 内容
 * @param {function} successCb 成功回调
 */
export const commonConfirm = async (title = '提示', content?: string, successCb?: () => any, Taro?: any) => {
    promisifyApiSimple('confirm',{
        title,
        content,
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        success: result => {
            const { confirm } = result;
            if (confirm) {
              successCb && successCb();
            }
        }
    },null,Taro)
};
/**
 * 获取系统信息
 */
export const getSystemInfo = async (Taro?: any) => {
    return await promisifyApi('getSystemInfo', {}, Taro)
};
/**
 * 执行关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export const favorShop = async (sellerId?: number, Taro?: any) => {
    if (!sellerId) {
      return false;
    }
    let result: { error?: number } = await promisifyApiToTb('favorShop',{ id: +sellerId },Taro)
    if(result?.error === 11) return false
    if(result?.error === 12) return true
    return result
};
/**
 * 判断是否关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export const checkShopFavoredStatus = async (sellerId?: number, Taro?: any) => {
    if (!sellerId) {
      return false;
    }
    let result: { isFavor?: boolean } = await promisifyApiToTb('checkShopFavoredStatus',{ id: +sellerId },Taro)
    if(result?.isFavor !== undefined) return result.isFavor
    if(result === 'checkShopFavoredStatus 仅支持真机调用，请在手机淘宝中运行')return true
    return result
};
/**
 * 跳转到外部链接
 * @param {string} url 跳转链接
 */
export const navigateToOutside = (url: string, Taro?: any) => {
    if (!url) {
      console.error('navigateToOutside: 请传入url');
      return false;
    }
    promisifyApiSimple('call',{
        url
    }, 'navigateToOutside',Taro)
};
/**
 * 跳转到内部链接（新开窗口）
 * @param {string} url 跳转链接
 */
export const navigateTo = (url: string, Taro?: any) => {
    if (!url) {
      console.error('navigateTo: 请传入url');
      return false;
    }
    promisifyApiSimple('navigateTo',{
        url
    }, null, Taro)
};
/**
 * 返回页面
 * @param {number} delta
 */
export const navigateBack = (delta?: number, Taro?: any) => {
    promisifyApiSimple('navigateBack',{
        delta
    },null,Taro)
};
/**
 * 跳转到内部链接（不新开窗口）
 * @param {string} url
 */
export const redirectTo = (url: string, Taro?: any) => {
    if (!url) {
      console.error('redirectTo: 请传入url');
      return false;
    }
    promisifyApiSimple('redirectTo',{
        url
    },null,Taro)
};
/**
 * 获取服务器时间
 * @returns {number} 服务器时间戳
 */
export const getServerTime = async (Taro?: any) => {
    const result: { time?: string } = await promisifyApi('getServerTime', {},Taro)
    if(result?.time) return result.time
    return result
};
/**
 * 收藏商品
 * @param {number} 商品id
 * @returns {object} 收藏结果
 */
export const collectGoods = async (id: number,Taro?: any) => {
    if (!id) {
      console.error('collectGoods: 请传入商品id');
      return false;
    }
    let result: { error?: number } = await promisifyApiToTb('collectGoods',{ id: +id },Taro)
    if(result?.error === 11) return false
    return result
};
/**
 * 查询商品收藏状态
 * @param {number} 商品id
 * @returns {boolean} 商品收场状态
 */
export const checkGoodsCollectedStatus = async (id: number, Taro?: any) => {
    if (!id) {
      console.error('checkGoodsCollectedStatus: 请传入商品id');
      return false;
    }
    let result: { isCollect?: boolean } = await promisifyApiToTb('checkGoodsCollectedStatus',{ id: +id },Taro)
    if(result?.isCollect) return result.isCollect
    return result
};
/**
 * 跳转到淘宝商品页
 * @param {string} itemId 商品ID
 */
export const openDetail = async (itemId: string, Taro?: any) => {
    if (!itemId) {
      console.error('openDetail: 请传入商品id');
      return false;
    }
    return await promisifyApiToTb('openDetail',{ itemId: String(itemId) },Taro)
};
/**
 * 创建音频实例
 * @param {object} opts 配置对象 例 { src: '音频链接', autoplay: false }
 */
export const createAudio = (opts: { src: string, autoplay?: boolean},Taro?: any) => {
    const audioInstance = new AudioModel({ Taro, ...opts });
    return audioInstance;
};
/**
 * 获取图片信息
 * @param {string} src 图片地址
 */
export const getImageInfo = async (src: string, Taro?: any) => {
    return await promisifyApi('getImageInfo', { src }, Taro)
};
/**
 * 剪切板
 * @param {text: string} 
 */
export const setClipboard = async (text: string, Taro?: any) => {
	return await promisifyApi('setClipboard', { text }, Taro)
};
/**
 * 调起分享面板
 */
export const showSharePanel = async (Taro?: any) => {
    promisifyApiSimple('showSharePanel',{}, null,Taro)
}
/**
 * 隐藏分享面板
 */
export const hideShareMenu = async (Taro?: any) => {
    promisifyApiSimple('hideShareMenu',{},null,Taro)
}
/**
 * 获取缓存数据
 * @param key 
 */
export const getStorage = async (key: string, Taro?: any) => {
    const result: { data?: string} = await promisifyApi('getStorage', { key }, Taro)
    if(result?.data) return result.data
    return undefined
}
/**
 * 设置缓存数据
 * @param key 
 * @param value 
 */
export const setStorage = async (key: string, value: any, Taro?: any) => {
    return await promisifyApi('setStorage', { key, data: value }, Taro)
}
/**
 * 清除缓存数据
 * @param key 
 */
export const removeStorage = async (key: string, Taro?: any) => {
    return await promisifyApi('removeStorage', { key }, Taro)
}
/**
 * 自定义分析数据的上报接口
 * @param eventType 
 * @param logkey 
 */
export const taobaoReportClick = (eventType: string,logkey: string) => {
    // @ts-ignore
    my.reportAnalytics(eventType, {
        // 标志某一类事件，方便数据分析进行分组
        'logkey': logkey
    })
};
/**
 * 打开BC客服聊天
 * @param sellerNick 
 * @param itemId 
 */
export const openMessage = async (param:{ sellerNick: string, itemId: string }, Taro?: any) => {
    const { sellerNick, itemId } = param
    let result = await promisifyApiToTb('openMessage',{ sellerNick, forceH5: false, params: { itemId } }, Taro)
    return result
}
/**
 * 显示指定商品 SKU 选择器
 * @param itemId 
 */
export const showSkuModal = async (itemId: string, Taro?: any) => {
    let result = await promisifyApiToTb('showSku',{ itemId }, Taro)
    return result
}
/**
 * 隐藏正在展示的商品 SKU 选择器
 */
export const hideSkuModal = async (Taro?: any) => {
    let result = await promisifyApiToTb('hideSku',{}, Taro)
    return result
}
/**
 * 跳转订单页
 * @param itemId 
 * @param skuId 
 * @param quantity 
 */
export const confirmCustomOrder = async (param: { itemId: number, skuId?: number, quantity?: number }, Taro?: any) => {
    const { itemId, skuId, quantity } = param
    let result = await promisifyApiToTb('confirmCustomOrder',{ 
        data: { 
            itemId, 
            skuId: skuId || -1, 
            quantity: quantity || 1, 
            customization: {} 
        }
    }, Taro)
    return result
}
// 获取授权信息
export const getSetting = async (Taro?: any) => {
    // @ts-ignore
    const _Taro = Taro || my
    return new Promise(async (resolve,reject) => {
        _Taro.getSetting({
            success: (res) => {
                resolve(res)
            },
        });
    })
}
// 打开授权设置
export const openSetting = async (Taro?: any) => {
    // @ts-ignore
    const _Taro = Taro || my
    return new Promise(async (resolve,reject) => {
        _Taro.openSetting({
            success: (res) => {
                resolve(res)
            },
        });
    })
}
// 获取用户信息
export const getAuthUserInfo = async (Taro?: any) => {
    // @ts-ignore
    const _Taro = Taro || my
    return new Promise(async (resolve,reject) => {
        _Taro.getAuthUserInfo({
            success: (res) => {
                resolve(res)
            },
        });
    })
}
// 发起用户授权{ groupChat: 群聊, userInfo: 用户基本信息, addressList: 地址列表, clipboard: 粘贴 }
export const authorize = async (scopeInfo, Taro?: any) => {
    // @ts-ignore
    const _Taro = Taro || my
    return new Promise(async (resolve,reject) => {
        _Taro.authorize({
            scopes: scopeInfo || 'scope.userInfo',
            success: (res) => {
                resolve(res)
            },
            fail: (err) => {
                reject(err)
            }
        });
    })
}