"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.receiveMemberEname = exports.receiveEnamePrize = exports.receiveObjectPrize = void 0;
var tb_1 = require("../core/tb");
var tbFn_1 = require("../core/tbFn");
var utils_1 = require("../utils");
// 领取实物
var getUerAddressParam = function () { return __awaiter(void 0, void 0, void 0, function () {
    var userAddress, _a, name, telNumber, provinceName, cityName, cityCode, countyName, detailInfo, streetName, params;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0: return [4 /*yield*/, tbFn_1.getUserAddress().catch(function (err) {
                    tb_1.commonToast(err.errorMessage);
                })];
            case 1:
                userAddress = _b.sent();
                if (!userAddress)
                    return [2 /*return*/, false];
                _a = userAddress || {}, name = _a.name, telNumber = _a.telNumber, provinceName = _a.provinceName, cityName = _a.cityName, cityCode = _a.cityCode, countyName = _a.countyName, detailInfo = _a.detailInfo, streetName = _a.streetName;
                params = {
                    name: name,
                    phone: telNumber,
                    addressDetail: detailInfo,
                    cityCode: cityCode,
                    city: cityName,
                    province: provinceName,
                    area: countyName,
                    streetName: streetName,
                };
                return [2 /*return*/, {
                        params: params,
                        duibaAddress: userAddress.duibaAddress.address
                    }];
        }
    });
}); };
var confirmAddress = function (address) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    // @ts-ignore
                    my.confirm({
                        title: '提示',
                        content: '确认使用该收货地址：' + address,
                        success: function (res) {
                            if (res.confirm) {
                                resolve(true);
                            }
                            else {
                                resolve(false);
                            }
                        },
                    });
                    return [2 /*return*/];
                });
            }); })];
    });
}); };
/**
 * 领取实物奖品
 * @param api
 * @param data
 */
var receiveObjectPrize = function (api, data) { return __awaiter(void 0, void 0, void 0, function () {
    var params, successMsg, errorMsg;
    return __generator(this, function (_a) {
        params = data.params, successMsg = data.successMsg, errorMsg = data.errorMsg;
        return [2 /*return*/, new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
                var userInfo, _params, duibaAddress, name, phone, address, canPass, _a, success, data, message;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, getUerAddressParam()];
                        case 1:
                            userInfo = _b.sent();
                            if (!userInfo) {
                                resolve(false);
                                return [2 /*return*/];
                            }
                            _params = userInfo.params, duibaAddress = userInfo.duibaAddress;
                            name = _params.name, phone = _params.phone;
                            address = name + phone + duibaAddress;
                            return [4 /*yield*/, confirmAddress(address)];
                        case 2:
                            canPass = _b.sent();
                            if (!canPass) {
                                resolve(false);
                                return [2 /*return*/];
                            }
                            return [4 /*yield*/, api(__assign(__assign({}, params), _params))];
                        case 3:
                            _a = _b.sent(), success = _a.success, data = _a.data, message = _a.message;
                            if (success) {
                                tb_1.commonToast(successMsg);
                                resolve(true);
                            }
                            else {
                                tb_1.commonToast(errorMsg || message);
                                resolve(false);
                            }
                            return [2 /*return*/];
                    }
                });
            }); })];
    });
}); };
exports.receiveObjectPrize = receiveObjectPrize;
/**
 * 领取权益
 * @param api
 * @param data
 */
var receiveEnamePrize = function (api, data) { return __awaiter(void 0, void 0, void 0, function () {
    var params, successMsg, errorMsg;
    return __generator(this, function (_a) {
        params = data.params, successMsg = data.successMsg, errorMsg = data.errorMsg;
        return [2 /*return*/, new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
                var _a, success, data, message;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, api(params).catch(function (res) {
                                tb_1.commonToast(successMsg || res.message);
                                resolve(false);
                            })];
                        case 1:
                            _a = _b.sent(), success = _a.success, data = _a.data, message = _a.message;
                            if (success) {
                                tb_1.commonToast(successMsg);
                                resolve(true);
                            }
                            else {
                                tb_1.commonToast(errorMsg || message);
                                resolve(false);
                            }
                            return [2 /*return*/];
                    }
                });
            }); })];
    });
}); };
exports.receiveEnamePrize = receiveEnamePrize;
/**
 * 会员优惠券领取
 * @param api
 * @param data
 */
var receiveMemberEname = function (api, data) { return __awaiter(void 0, void 0, void 0, function () {
    var params, successMsg, errorMsg, sellerId, ename, ext;
    return __generator(this, function (_a) {
        params = data.params, successMsg = data.successMsg, errorMsg = data.errorMsg;
        sellerId = params.sellerId, ename = params.ename, ext = __rest(params, ["sellerId", "ename"]);
        if (!ename)
            return [2 /*return*/, false];
        return [2 /*return*/, new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
                var result, _a, success, data_1, message;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, utils_1.applyActivity({ sellerId: sellerId, activityId: ename })];
                        case 1:
                            result = _b.sent();
                            if (!result)
                                resolve(false);
                            if (!result.businessSuccess) return [3 /*break*/, 3];
                            return [4 /*yield*/, api(__assign({}, ext))];
                        case 2:
                            _a = _b.sent(), success = _a.success, data_1 = _a.data, message = _a.message;
                            if (success) {
                                tb_1.commonToast(successMsg || '奖品发放成功，请前往我的奖品处进行使用');
                                resolve(true);
                            }
                            else {
                                tb_1.commonToast(errorMsg || message);
                                resolve(false);
                            }
                            return [3 /*break*/, 4];
                        case 3:
                            tb_1.commonToast(result.errorMsg);
                            resolve(false);
                            _b.label = 4;
                        case 4: return [2 /*return*/];
                    }
                });
            }); })];
    });
}); };
exports.receiveMemberEname = receiveMemberEname;
//# sourceMappingURL=capiFn.js.map