"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.requestMock = exports.tornadoAPIFn = exports.tornadoAPICb = exports.md5 = void 0;
var tbFn_1 = require("../core/tbFn");
var tb_1 = require("../core/tb");
var index_1 = require("./index");
var Buffer = require("buffer").Buffer;
var crypto = require("crypto");
/**
 * 加密
 * @param data
 */
var md5 = function (data) {
    var buf = new Buffer(data);
    var str = buf.toString("binary");
    return crypto.createHash("md5").update(str).digest("hex").slice(0, 30);
};
exports.md5 = md5;
/**
 * my.request请求接口
 * @param params
 * @param res
 * @param loading
 * @param tornadoAPI
 */
var tornadoAPICb = function (params, res, loading, tornadoAPI) { return __awaiter(void 0, void 0, void 0, function () {
    var nickName, params_;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                nickName = res.nickName;
                params.openId = exports.md5(nickName);
                params_ = {
                    url: tornadoAPI,
                    method: 'post',
                    data: params,
                    dataType: 'json'
                };
                return [4 /*yield*/, index_1.myRequest(params_, loading)];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.tornadoAPICb = tornadoAPICb;
/**
 * 请求风池台接口数据
 * @param tornadoAPI
 * @param nickName
 * @param handle
 * @param loading
 * @param params
 */
var tornadoAPIFn = function (tornadoAPI, nickName, handle, loading, params) { return __awaiter(void 0, void 0, void 0, function () {
    var matchRes, db, proxyIp, data_, params_;
    return __generator(this, function (_a) {
        matchRes = tornadoAPI.match(/db=(\w*)&proxyIp=([\d]{1,3}\.[\d]{1,3}\.[\d]{1,3}\.[\d]{1,3})/);
        db = matchRes[1];
        proxyIp = matchRes[2];
        data_ = {
            handler: handle,
            data: params
        };
        console.log("data_", data_);
        params_ = {
            db: db,
            proxyIp: proxyIp,
            data: data_
        };
        if (!db || !proxyIp) {
            tb_1.commonConfirm('风驰台地址错误', '请确认风驰台的地址是否正确，未查找到db和proxyIp');
            return [2 /*return*/, false];
        }
        // nickName 转 md5 作为唯一的openId
        if (!nickName) {
            return [2 /*return*/, tbFn_1.getAuthUserInfo().catch(function (err) {
                    console.log('未授权成功', err);
                }).then(function (res) {
                    var _a = (res || {}).nickName, nickName = _a === void 0 ? '' : _a;
                    if (!nickName) {
                        console.warn('请先登录！');
                        return false;
                    }
                    return exports.tornadoAPICb(params_, res, loading, tornadoAPI);
                })];
        }
        return [2 /*return*/];
    });
}); };
exports.tornadoAPIFn = tornadoAPIFn;
/**
 * 请求mock数据
 * @param reqConfig
 * @param initConfig
 * @param params
 */
var requestMock = function (reqConfig, initConfig, params) { return __awaiter(void 0, void 0, void 0, function () {
    var cloudName, handle, method, isShowLoading, requestType, tornadoAPI, nickName, mockUrlPrefix, mockUrl, requestPrefix, params_;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                cloudName = reqConfig.cloudName, handle = reqConfig.handle, method = reqConfig.method, isShowLoading = reqConfig.isShowLoading;
                requestType = initConfig.requestType, tornadoAPI = initConfig.tornadoAPI, nickName = initConfig.nickName, mockUrlPrefix = initConfig.mockUrlPrefix, mockUrl = initConfig.mockUrl;
                if (!(requestType === 'tornadoAPI')) return [3 /*break*/, 2];
                return [4 /*yield*/, exports.tornadoAPIFn(tornadoAPI, nickName, handle, isShowLoading, params)];
            case 1: return [2 /*return*/, _a.sent()];
            case 2:
                requestPrefix = mockUrl || mockUrlPrefix[requestType];
                params_ = {
                    url: requestPrefix + cloudName + '.' + handle,
                    method: 'get',
                    data: params,
                    dataType: 'json'
                };
                return [4 /*yield*/, index_1.myRequest(params_, isShowLoading)];
            case 3: return [2 /*return*/, _a.sent()];
        }
    });
}); };
exports.requestMock = requestMock;
//# sourceMappingURL=requestFn.js.map