import { 
    promisifyApi,
    getTmallMemberStatus,
    strategyEname
} from '../helpers'
/**
 * 获取淘宝用户收货地址
 */
export const getUserAddress = async (opts = {}) => {
    let defaults = {
      addAddress: 'show',
      searchAddress: 'hide',
      locateAddress: 'hide',
      joinTag: '' // 分割收货地址符号（淘宝商家有特定发货需求）
    };
    let _opts = Object.assign({}, defaults, opts);
    // @ts-ignore
    return new Promise((resolve, reject) => {
      my.authorize({
        scopes: 'scope.addressList',
        success: () => {
          const { addAddress, searchAddress, locateAddress, joinTag } = _opts;
          if (!my.tb.chooseAddress) {
            reject({
              noSupport: true,
              errorMessage: '当前版本不支持选择收货地址，请升级到最新版本'
            });
            return false;
          }
          my.tb.chooseAddress(
            {
              addAddress,
              searchAddress,
              locateAddress
            },
            res => {
              const { error, provinceName, countyName, cityName, streetName, detailInfo, name, telNumber } = res;
              // 如果有error为用户取消操作不做操作
              if (error) {
                resolve(false);
              } else {
                resolve({
                  ...res,
                  duibaAddress: {
                    name,
                    phone: telNumber,
                    address: [provinceName, cityName, countyName, streetName, detailInfo].join(joinTag)
                  }
                });
              }
            },
            res => {
              reject(res);
            }
          );
        },
        fail: err => {
          reject(err)
        }
      });
    });
};
/**
 * 选择图片
 * @param opts 
 */
export const chooseImage = async (opts = {}) => {
    let defaults = {
      count: 1,
      sourceType: ['camera', 'album'],
      compressLevel: 1
    };
    let _opts = Object.assign({}, defaults, opts);
    const { count, sourceType, compressLevel } = _opts;
    // @ts-ignore
    return new Promise((resolve, reject) => {
        if (!my.chooseImage) {
            reject({
            noSupport: true,
            errorMessage: '当前版本不支持选择图片，请升级到最新版本'
            });
            return false;
        }
        my.chooseImage({
            count,
            sourceType,
            success: res => {
              my.compressImage({
                    apFilePaths: res.apFilePaths,
                    level: compressLevel,
                    success: data => {
                        resolve(data);
                    },
                    fail: err => {
                        resolve(err);
                    }
                });
            },
            fail: err => {
                // error code 2001 为摄像头授权取消、ios 11为用户取消操作不认作失败场景 、安卓 为1
                if (err.error !== 2001 && err.error !== 11 && err.error !== 1) {
                    reject(err);
                } else {
                    resolve(false);
                }
            }
      });
    });
};
/**
 * 获取图片信息
 * @param {*} opts chooseImage配置参数
 */
export const uploadImage = async (opts = {}) => {
    // @ts-ignore
    const { cloud } = getApp();
    if (!cloud) {
      console.error('chattingSendCard: 请传入app.cloud');
      return false;
    }
    const chooseImageResult: { apFilePaths?: Array<{}>} = await chooseImage(opts).catch(err => {
      console.error('选择图片失败')
    });
    if (chooseImageResult) {
      const { apFilePaths } = chooseImageResult;
      const filePath = apFilePaths[0];
      const imageInfo: { path?: string } = await promisifyApi('getImageInfo', { src: filePath })
      // 找不到图片信息
      if (!imageInfo) {
        return false;
      }
      const { path: imagePath } = imageInfo;
      const { url } = await cloud.file.uploadFile({
        filePath,
        fileType: 'image',
        fileName: imagePath.split('/').pop()
      });
      return url;
    }
    return false;
}
/**
 * 获取授权用户信息
 * @returns {object} 用户登录信息
 */
export const getAuthUserInfo = () => {
    return new Promise((resolve, reject) => {
        my.getAuthUserInfo({
          success: userInfo => {
              resolve(userInfo);
          },
          fail: err => {
            my.authorize({
              scopes: 'scope.userInfo',
              success: () => {
                  console.log('执行 my.authorize')
                  // @ts-ignore
                  my.getAuthUserInfo({
                      success: userInfo => {
                          resolve(userInfo);
                      },
                      fail: err => {
                          reject(err);
                      }
                  });
              },
              fail: err => {
                  reject(err);
              }
          });
          }
      });
        // @ts-ignore
       
    });
};
/**
 * 获取用户会员状态(Tmall使用)
 */
export const getUserStatus = async () => {
  return new Promise((resolve, reject) => {
    // @ts-ignore
    my.authorize({
      scopes: "scope.campus.audit",
      success: async () => {
        const result = await getTmallMemberStatus()
        resolve(result.result);
      },
      fail: (err) => {
        console.log(err);
        reject(err);
      },
    });
  });
}
/**
 * 拉菲奖品发放(Tmall使用)
 * @param params 
 */
export const cloudTBIssue = async (params: { channel: string, strategyCode: string, code: string }) => {
  return new Promise((resolve, reject) => {
    // @ts-ignore
    my.authorize({
      scopes: "scope.latourBenefit",
      success: async () => {
        const result = await strategyEname(params)
        console.log(result, "result");
        resolve(result);
      },
      fail: (err) => {
        console.log(err);
        reject(err);
      },
    });
  });
}
/**
 * 分享到群聊卡片
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
export const chattingSendCard = async (requestInfo: IRequestInfo) => {
	// @ts-ignore
	const { cloud } = getApp();
	if (!cloud) {
	  console.error('chattingSendCard: 请传入app.cloud');
	  return false;
	}
  
	if (!requestInfo) {
	  console.error('chattingSendCard: 请传入卡片请求参数');
	  return false;
	}
	return new Promise((resolve, reject) => {
		// @ts-ignore
		my.authorize({
			scopes: 'scope.groupChat',
			success: async () => {
				const result = await cloud.topApi
					.invoke({
						api: 'taobao.chatting.platform.message.sendcard',
						data: { request_info: JSON.stringify(requestInfo) }
					})
					.catch(err => {
						reject(err);
					});
				if (result) {
					const { error } = result;
					if (error) {
						resolve(false);
					} else {
						resolve(result);
					}
				}
			},
			fail: err => {
				if (err.error === 11) {
					// error code 11 为用户取消操作不认作失败场景
					resolve(false);
				}
				reject(err);
			}
		});
	});
};
/**
 * 文本风险校验
 * @param {string} text 文本
 */
export const textRiskIdentification = async (text: string) => {
	return new Promise((resolve, reject) => {
		// @ts-ignore
		if (!my.tb.textRiskIdentification) {
			reject({
			noSupport: true,
			errorMessage: '不支持文本校验'
			});
		}
		// @ts-ignore
		my.tb.textRiskIdentification({
			data:{
				text
			},
			success: res => {
				if (res.data && res.data.result) {
					const { suggestion }= res.data.result;
					if (suggestion === 'pass') {
					resolve(true);
					}
				}
				resolve(false);
			},
			fail: err => {
				reject(err)
			},
		})
	})
}
/**
 * 跳转店铺首页
 * @param {string} shopId
 */
export const navigateToTaobaoPage = (shopId: string) => {
	return new Promise((resolve, reject) => {
		// @ts-ignore
		my.tb.navigateToTaobaoPage({
			appCode:'shop',
			appParams:{
				shopId: String(shopId),
				weexShopTab:"shopindexbar",
				weexShopSubTab:"shopindex"
			},
			success: (res) => {
				resolve(true)
			},
			fail: (res) => {
				reject(res.error)
			}
		});
	})
}