import * as utils from './utils';
import * as constants from './constants';
import * as capiFn from './request/capiFn';
declare const _default: {
    capi: {
        getMyAwardsList: {
            method: string;
            handle: string;
            isShowLoading: boolean;
        };
        receiveObjectPrize: {
            method: string;
            handle: string;
        };
        receiveEnamePrize: {
            method: string;
            handle: string;
        };
        completeTask: {
            method: string;
            handle: string;
        };
        receiveTask: {
            method: string;
            handle: string;
        };
        getTaskList: {
            method: string;
            handle: string;
        };
        getCollectGoods: {
            method: string;
            handle: string;
        };
    };
    capiFn: typeof capiFn;
    tb: {
        getUserAddress: (opts?: {}) => Promise<unknown>;
        chooseImage: (opts?: {}) => Promise<unknown>;
        uploadImage: (opts?: {}) => Promise<any>;
        getAuthUserInfo: () => Promise<unknown>;
        getUserStatus: () => Promise<unknown>;
        cloudTBIssue: (params: {
            channel: string;
            strategyCode: string;
            code: string;
        }) => Promise<unknown>;
        chattingSendCard: (requestInfo: IRequestInfo) => Promise<unknown>;
        textRiskIdentification: (text: string) => Promise<unknown>;
        navigateToTaobaoPage: (shopId: string) => Promise<unknown>;
        commonToast: (content: string, duration?: number, successCb?: () => any) => void;
        showToast: (params: {
            content: string;
            duration?: number;
            success?: () => any;
        }, Taro?: any) => void;
        simpleAlert: (content: string, Taro?: any) => void;
        commonConfirm: (title?: string, content?: string, successCb?: () => any, Taro?: any) => Promise<void>;
        getSystemInfo: (Taro?: any) => Promise<unknown>;
        favorShop: (sellerId?: number, Taro?: any) => Promise<boolean | {
            error?: number;
        }>;
        checkShopFavoredStatus: (sellerId?: number, Taro?: any) => Promise<boolean | {
            isFavor?: boolean;
        }>;
        navigateToOutside: (url: string, Taro?: any) => boolean;
        navigateTo: (url: string, Taro?: any) => boolean;
        navigateBack: (delta?: number, Taro?: any) => void;
        redirectTo: (url: string, Taro?: any) => boolean;
        getServerTime: (Taro?: any) => Promise<string | {
            time?: string;
        }>;
        collectGoods: (id: number, Taro?: any) => Promise<false | {
            error?: number;
        }>;
        checkGoodsCollectedStatus: (id: number, Taro?: any) => Promise<boolean | {
            isCollect?: boolean;
        }>;
        openDetail: (itemId: string, Taro?: any) => Promise<unknown>;
        createAudio: (opts: {
            src: string;
            autoplay?: boolean;
        }, Taro?: any) => import("./helpers").AudioModel;
        getImageInfo: (src: string, Taro?: any) => Promise<unknown>;
        setClipboard: (text: string, Taro?: any) => Promise<unknown>;
        showSharePanel: (Taro?: any) => Promise<void>;
        hideShareMenu: (Taro?: any) => Promise<void>;
        getStorage: (key: string, Taro?: any) => Promise<string>;
        setStorage: (key: string, value: any, Taro?: any) => Promise<unknown>;
        removeStorage: (key: string, Taro?: any) => Promise<unknown>;
        taobaoReportClick: (eventType: string, logkey: string) => void;
        openMessage: (param: {
            sellerNick: string;
            itemId: string;
        }, Taro?: any) => Promise<unknown>;
        showSkuModal: (itemId: string, Taro?: any) => Promise<unknown>;
        hideSkuModal: (Taro?: any) => Promise<unknown>;
        confirmCustomOrder: (param: {
            itemId: number;
            skuId?: number;
            quantity?: number;
        }, Taro?: any) => Promise<unknown>;
        getSetting: (Taro?: any) => Promise<unknown>;
        openSetting: (Taro?: any) => Promise<unknown>;
        authorize: (scopeInfo: any, Taro?: any) => Promise<unknown>;
    };
    utils: typeof utils;
    request: (header: IRequest) => false | ((handle: any, method: string, params: any, ext?: {
        cloudName?: string;
        isShowLoading?: boolean;
        toastError?: boolean;
    }) => Promise<unknown>);
    constants: typeof constants;
};
export default _default;
