import { AudioModel } from '../helpers';
/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
export declare const commonToast: (content: string, duration?: number, successCb?: () => any) => void;
/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
export declare const showToast: (params: {
    content: string;
    duration?: number;
    success?: () => any;
}, Taro?: any) => void;
/**
 * 简易alert
 * @param {string} content toast内容
 */
export declare const simpleAlert: (content: string, Taro?: any) => void;
/**
 * 通用确认弹窗
 * @param {string} title 标题
 * @param {string} content 内容
 * @param {function} successCb 成功回调
 */
export declare const commonConfirm: (title?: string, content?: string, successCb?: () => any, Taro?: any) => Promise<void>;
/**
 * 获取系统信息
 */
export declare const getSystemInfo: (Taro?: any) => Promise<unknown>;
/**
 * 执行关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export declare const favorShop: (sellerId?: number, Taro?: any) => Promise<boolean | {
    error?: number;
}>;
/**
 * 判断是否关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export declare const checkShopFavoredStatus: (sellerId?: number, Taro?: any) => Promise<boolean | {
    isFavor?: boolean;
}>;
/**
 * 跳转到外部链接
 * @param {string} url 跳转链接
 */
export declare const navigateToOutside: (url: string, Taro?: any) => boolean;
/**
 * 跳转到内部链接（新开窗口）
 * @param {string} url 跳转链接
 */
export declare const navigateTo: (url: string, Taro?: any) => boolean;
/**
 * 返回页面
 * @param {number} delta
 */
export declare const navigateBack: (delta?: number, Taro?: any) => void;
/**
 * 跳转到内部链接（不新开窗口）
 * @param {string} url
 */
export declare const redirectTo: (url: string, Taro?: any) => boolean;
/**
 * 获取服务器时间
 * @returns {number} 服务器时间戳
 */
export declare const getServerTime: (Taro?: any) => Promise<string | {
    time?: string;
}>;
/**
 * 收藏商品
 * @param {number} 商品id
 * @returns {object} 收藏结果
 */
export declare const collectGoods: (id: number, Taro?: any) => Promise<false | {
    error?: number;
}>;
/**
 * 查询商品收藏状态
 * @param {number} 商品id
 * @returns {boolean} 商品收场状态
 */
export declare const checkGoodsCollectedStatus: (id: number, Taro?: any) => Promise<boolean | {
    isCollect?: boolean;
}>;
/**
 * 跳转到淘宝商品页
 * @param {string} itemId 商品ID
 */
export declare const openDetail: (itemId: string, Taro?: any) => Promise<unknown>;
/**
 * 创建音频实例
 * @param {object} opts 配置对象 例 { src: '音频链接', autoplay: false }
 */
export declare const createAudio: (opts: {
    src: string;
    autoplay?: boolean;
}, Taro?: any) => AudioModel;
/**
 * 获取图片信息
 * @param {string} src 图片地址
 */
export declare const getImageInfo: (src: string, Taro?: any) => Promise<unknown>;
/**
 * 剪切板
 * @param {text: string}
 */
export declare const setClipboard: (text: string, Taro?: any) => Promise<unknown>;
/**
 * 调起分享面板
 */
export declare const showSharePanel: (Taro?: any) => Promise<void>;
/**
 * 隐藏分享面板
 */
export declare const hideShareMenu: (Taro?: any) => Promise<void>;
/**
 * 获取缓存数据
 * @param key
 */
export declare const getStorage: (key: string, Taro?: any) => Promise<string>;
/**
 * 设置缓存数据
 * @param key
 * @param value
 */
export declare const setStorage: (key: string, value: any, Taro?: any) => Promise<unknown>;
/**
 * 清除缓存数据
 * @param key
 */
export declare const removeStorage: (key: string, Taro?: any) => Promise<unknown>;
/**
 * 自定义分析数据的上报接口
 * @param eventType
 * @param logkey
 */
export declare const taobaoReportClick: (eventType: string, logkey: string) => void;
/**
 * 打开BC客服聊天
 * @param sellerNick
 * @param itemId
 */
export declare const openMessage: (param: {
    sellerNick: string;
    itemId: string;
}, Taro?: any) => Promise<unknown>;
/**
 * 显示指定商品 SKU 选择器
 * @param itemId
 */
export declare const showSkuModal: (itemId: string, Taro?: any) => Promise<unknown>;
/**
 * 隐藏正在展示的商品 SKU 选择器
 */
export declare const hideSkuModal: (Taro?: any) => Promise<unknown>;
/**
 * 跳转订单页
 * @param itemId
 * @param skuId
 * @param quantity
 */
export declare const confirmCustomOrder: (param: {
    itemId: number;
    skuId?: number;
    quantity?: number;
}, Taro?: any) => Promise<unknown>;
export declare const getSetting: (Taro?: any) => Promise<unknown>;
export declare const openSetting: (Taro?: any) => Promise<unknown>;
export declare const getAuthUserInfo: (Taro?: any) => Promise<unknown>;
export declare const authorize: (scopeInfo: any, Taro?: any) => Promise<unknown>;
