/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
export declare const commonToast: (content: any, duration: number, successCb: any) => string;
/**
 * 简易alert
 * @param {string} content toast内容
 */
export declare const simpleAlert: (content: any) => void;
/**
 * 获取授权用户信息
 * @returns {object} 用户登录信息
 */
export declare const getAuthUserInfo: () => Promise<{
    nickName: string;
    avatar: string;
    mixNick: string;
}>;
/**
 * 获取系统信息
 * @returns {object} 小程序系统信息
 */
export declare const getSystemInfo: () => Promise<{
    version: string;
}>;
/**
 * 执行关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export declare const favorShop: (sellerId: any) => Promise<boolean>;
/**
 * 判断是否关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export declare const checkShopFavoredStatus: (sellerId: any) => Promise<boolean>;
/**
 * 跳转到外部链接
 * @param {string} url 跳转链接
 */
export declare const navigateToOutside: (url: any) => boolean;
/**
 * 跳转到内部链接（新开窗口）
 * @param {string} url 跳转链接
 */
export declare const navigateTo: (url: any) => boolean;
/**
 * 跳转到内部链接（不新开窗口）
 * @param {string} url 跳转链接
 */
export declare const redirectTo: (url: any) => boolean;
/**
 * 获取服务器时间
 * @returns {number} 服务器时间戳
 */
export declare const getServerTime: () => Promise<number>;
/**
 * 收藏商品
 * @param {number} 商品id
 * @returns {object} 收藏结果
 */
export declare const collectGoods: (id: any) => Promise<boolean>;
/**
 * 查询商品收藏状态
 * @param {number} 商品id
 * @returns {boolean} 商品收场状态
 */
export declare const checkGoodsCollectedStatus: (id: any) => Promise<boolean>;
/**
 * 跳转到淘宝商品页
 * @param {string} itemId 商品ID
 */
export declare const openDetail: (itemId: any) => Promise<boolean>;
/**
 * 获取淘宝用户收货地址
 */
export declare const getUserAddress: (opts?: {}) => Promise<{
    name: number;
    phone: number;
    address: number;
}>;
/**
 * 分享到群聊卡片
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
export declare const chattingSendCard: (requestInfo: any) => Promise<boolean>;
/**
 * 分享到群聊卡片
 * @param {*} cloud 小程序云
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
export declare const textRiskIdentification: (text: any) => Promise<boolean>;
