const {
  cloud
} = getApp()
const {
  function: fc
} = cloud
const plugin = requirePlugin('myPlugin')
import {
  bizCode
} from '../../config';
import {
  queryBenefitByEname
} from '../../api';

import { chooseImage, getImageInfo, validateRangeNumber } from '/utils';


const EQUITY_TYPE = 2;
const CREDITS_TYPE = 3;
const OBJECT_TYPE = 4;
const THANKS_TYPE = 5;

Component({
  mixins: [],
  data: {
    EQUITY_TYPE,
    CREDITS_TYPE,
    OBJECT_TYPE,
    THANKS_TYPE,
    showDialogMask: true,
    dialogTop: '',
    rankTips: {
      status: 'success',
      content: ''
    },
    imageTips: {
      status: 'success',
      content: ''
    },
    probablityTips: {
      status: 'success',
      content: ''
    },
    prizeNameTips: {
      status: 'success',
      content: ''
    },
    prizeNumberTips: {
      status: 'success',
      content: ''
    },
    creditsValueTips: {
      status: 'success',
      content: ''
    },
    prizeInitData: {
      ename: '',
      id: '',
      restStock: '',
      activityOutId: '',
      type: 2,
      image: '',
      credits: '',
      probablity: '',
      name: ''
    }
  },
  props: {
    prizeDialogData: {
      index: '',
      record: {}
    },
    activityOutId: '',
    prizeDialogEdit: false,
    showPrize: false,
    hasEditPrize: false,
    datasource: [],
    onCloseDialog: function () {},
    onUpdateLevel: function () {},
    onUpdateHasChange: function () {},
  },
  didMount() {
    this.initPosition()
    let that = this
    const bridge = {
      bizCode, //此处输入想配置的商家应用appID
      //这个方法用于获取插件中用户选择的奖池enname
      async getCheckBenefitID({ ename, poolID }) {
        that.setData({
          prizeInitData: {
            ...that.data.prizeInitData,
            ename
          }
        })
        my.showToast({
          type: 'success',
          content: '已选择权益奖品'
        })
        const { success, data, message } = await queryBenefitByEname({ ename })
        if (success) {
          const { benefitName, rightTypeId, startTime, endTime, restStock } = data[0];
          that.setData({
            prizeInitData: {
              ...that.data.prizeInitData,
              name: benefitName,
              type: rightTypeId,
              startTime,
              endTime,
              restStock
            }
          })
          that.$page.data.backPageTimeOut = setTimeout(() => {
            my.navigateBack({
              delta: 1
            })
          }, 6000)
        } else {

          my.showToast({
            type: 'fail',
            content: message
          })
        }
      }
    }
    this.resetPrizeInit()
    plugin.setBridge(bridge)
  },
  methods: {
    initPosition() {
      const {
        scrollTop
      } = this.$page.data
      this.setData({
        dialogTop: scrollTop * 2
      })
    },
    onPrizeTypeChange(e) {
      let value = e.detail.value;
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          type: value
        }
      })
    },
    navigateToPlugin() {
      clearTimeout(this.$page.data.backPageTimeOut)
      my.navigateTo({
        url: 'plugin://myPlugin/orightindex-page'
      })
    },
    resetPrizeInit() {
      if (this.props.prizeDialogEdit) {
        const {
          rank,
          ...rest
        } = this.props.prizeDialogData.record
        this.setData({
          prizeInitData: {
            ...rest
          }
        })
      }
    },
    async uploadImage() {
      try {
        this.setData({
          showDialogMask: false
        })
        const res = await chooseImage();

        if (!res.apFilePaths.length) return

        const {
          height,
          width,
          type,
          path
        } = await getImageInfo({
          src: res.apFilePaths[0]
        });

        let imgBool = ~path.indexOf('.png') || ~path.indexOf('.jpg')
        if (height !== 300 || width !== 300 || !imgBool) {
          this.showItemTips('imageTips', 'error', '请按要求上传图片');
        } else {
          this.showItemTips('imageTips', 'success', '');
        }

        const {
          url
        } = await cloud.file.uploadFile({
          filePath: res.apFilePaths[0],
          fileType: 'image',
          fileName: path.split('/').pop()
        })

        this.setData({
          prizeInitData: {
            ...this.data.prizeInitData,
            image: url
          }
        })

      } catch (error) {
        this.setData({
          showDialogMask: true
        })
        console.error(error)
      }
    },
    onChangePrizeValue(e) {
      const key = e.target.dataset.name;
      const value = e.detail.value;
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          [key]: value
        }
      })

    },
    changeInput(e) {
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          name: e.detail.value
        }
      })
    },
    updatePrize() {
      const {
        name,
        ename,
        image,
        type,
        startTime,
        probablity,
        restStock,
        credits,
        endTime
      } = this.data.prizeInitData
      const {
        imageTips
      } = this.data;

      let probablityRexp = /^\d+(\.\d{1,2})?$/;
      if (!probablityRexp.test(probablity) ||  probablity > 100) {
        this.showItemTips('probablityTips', 'error', '奖品概率必须在0-100%之间且最多支持两位小数');
      } else {
        this.showItemTips('probablityTips', 'success', '');
      }
      const {
        LUKCY_POCKET_TYPE,
        COUPON_TYPE,
        CREDITS_TYPE,
        OBJECT_TYPE,
        THANKS_TYPE,
      } = this.data;

      if (type === LUKCY_POCKET_TYPE && !ename) {
        my.showToast({
          type: 'fail',
          content: '优惠券配置错误, 请重新配置'
        });
        return;
      }

      if((type == OBJECT_TYPE || type == CREDITS_TYPE) &&!name) {
        this.showItemTips('prizeNameTips', 'error', '请输入奖品名称')
      } else {
        this.showItemTips('prizeNameTips', 'success', '')
      }

      if ((type == OBJECT_TYPE) && !validateRangeNumber(restStock, [0, 9999])) {
        this.showItemTips('prizeNumberTips', 'error', '奖品库存为0-9999之间的整数');
      } else {
        this.showItemTips('prizeNumberTips', 'success', '');
      } 

      if (type == CREDITS_TYPE && !validateRangeNumber(credits, [0, 999])) {
        this.showItemTips('creditsValueTips', 'error', '请输入积分价值为0-999的整数');
      } else {
        this.showItemTips('creditsValueTips', 'success', '');
      }

      const { probablityTips, prizeNumberTips, creditsValueTips } = this.data;
      const isImagePass = image && imageTips.status !== 'error';
      const isEquietyPass = (type == EQUITY_TYPE) && name && isImagePass && ename && probablityTips.status !== 'error';
      const isObjectPass = type == OBJECT_TYPE && name && restStock && isImagePass && probablityTips.status !== 'error' && prizeNumberTips.status !== 'error';
      const isCreditsPass = type == CREDITS_TYPE && name && credits && isImagePass && probablityTips.status !== 'error' && creditsValueTips.status !== 'error';


      if (
        isEquietyPass || isObjectPass || isCreditsPass
      ) {
        this.props.onUpdateLevel({
            image,
            name,
            ename,
            type,
            probablity,
            restStock,
            credits
          },
          this.props.prizeDialogData.index
        )
        if (this.props.activityOutId) {
          this.props.onUpdateHasChange(true, this.props.prizeDialogData.index);
        }
        this.closePrize();
      } else {
        my.showToast({
          type: 'fail',
          content: '请完整填写奖品信息'
        })
      }
    },
    showItemTips(type, status, content) {
      this.setData({
        [type]: {
          status,
          content
        }
      })
    },
    closePrize() {
      this.setData({
        showDialogMask: true
      })
      this.props.onCloseDialog('prize')
    }
  }
})