const {
  cloud
} = getApp();

import { requestType } from '../config';

const REQUEST_PREFIX = 'backstage';
const request = (url, method, params, ext = {}) => {
  const {
    isShowLoading
  } = ext;
  const hideMyLoading = () => {
    if (isShowLoading) {
      my.hideLoading();
    }
  };
  if (isShowLoading) {
    my.showLoading();
  }

  const requestAms = () => {
    return my.request({
      url: `https://ams.dui88.com/server/index.php?g=Web&c=Mock&o=simple&projectID=218&uri=${REQUEST_PREFIX}.${url}`,
      method,
      data: params,
      dataType: 'json'
    }).then(res => {
      hideMyLoading();
      return res.data;
    }).catch(() => {
      hideMyLoading();
    });
  }

  const requestCloud = () => {
    return cloud.function.invoke(REQUEST_PREFIX, params, url).then(res => {
      hideMyLoading();
      return res;
    }).catch(() => {
      hideMyLoading();
    });
  }

  return requestType === 'ams' ? requestAms() : requestCloud();
};

export default request;