export function debounce(fn, wait) {
  var timeout = null
  return function () {
    if (timeout !== null) clearTimeout(timeout)
    timeout = setTimeout(fn, wait)
  }
}

// 解决小数相加精度问题
export function addFloat(num1, num2) {
  var r1, r2, m
  r1 = num1.toString().split(".")[1] ? num1.toString().split(".")[1].length : 0
  r2 = num2.toString().split(".")[1] ? num2.toString().split(".")[1].length : 0
  m = Math.pow(10, Math.max(r1, r2))
  return (num1 * m + num2 * m) / m
}