/** @format */
export default class ActivityConfigService {
    activityconfigDao: IBaseDao;
    activityconfigPrizeDao: IBaseDao;
    constructor(context: Context);
    saveNewActivity(baseConfig: IActivityBaseInfo, prize: Array<IActivityPrize>, openId: string): Promise<any>;
    updateBaseConfigInfo(id: string, data: IActivityBaseInfo): Promise<any>;
    getPrizeInfoById(id: any): Promise<any>;
    updateDeleteStatusById(id: any): Promise<any>;
    deletePrizeByIds(ids: string[]): Promise<any>;
    insertAndUpdatePrize(activityId: string, allPrizeList: Array<IActivityPrize>, bothIds: string[]): Promise<{
        success: any[];
        failed: any[];
    }>;
    updateOnePrizeById(id: any, data: IActivityPrize): Promise<any>;
    insertPrizeByActivityId(activityId: any, data: any): Promise<any>;
    getAllOldPrizeList(activityId: string): Promise<any>;
    diffPrizeList(activityId: string, pirzeList: Array<IActivityPrize>): Promise<{
        deleteIds: string[];
        bothIds: string[];
    }>;
    updateActivity(activityId: any, data: any, prizeNoId: any): Promise<[unknown, unknown, unknown, unknown, unknown, unknown, unknown, unknown, unknown, unknown]>;
    getActivityListByOpenId(openId: string, { pageSize, pageNo }: {
        pageSize?: number;
        pageNo?: number;
    }): Promise<{
        list: any;
        total: any;
        pageSize: number;
        pageNo: number;
    }>;
    getActivityInfoByActivityId(activityId: string): Promise<{
        baseConfig: any;
        prizeConfig: any;
    }>;
    deleteActivityByActivityId(activityId: string): Promise<any>;
    getNodifyList(serverTime: any): Promise<any>;
    update2Process(_id: any): Promise<boolean>;
    update2Success(_id: any): Promise<boolean>;
    update2Fail(_id: any, message: any): Promise<boolean>;
    /**
     * 组装奖品数据
     *
     * @param {Array<IActivityPrize>} prizeConfig
     * @returns
     * @memberof ActivityConfigService
     */
    formatPrizeConfig(prizeConfig: Array<IActivityPrize>): {};
    setPrizeProbalityRange(prizes: IActivityPrize[]): IActivityPrize[];
}
