import React, { memo } from 'react'
import { View } from '@tarojs/components'
import styles from './RankTitle.module.less'

const RankTitle = memo((props) => {
  const {
    titleList = ['排名', '用户名', '人气值'],
    myRank = { rank: '11', userNick: '用户名', rankValue: '534443' }
  } = props
  return (
    <View className={styles['rank-box']}>
      <View className={styles['rank-box__title']}>
        {titleList.map(val => {
          return <View className={styles['box-itm']}>{val}</View>
        })}
      </View>
      <View className={styles['rank-box__info']}>
        <View className={styles['box-itm']}>{myRank.rank}</View>
        <View className={styles['box-itm']}>{myRank.userNick}</View>
        <View className={styles['box-itm']}>{myRank.rankValue}</View>
      </View>
    </View>
  )
})
export default RankTitle
