## 参数

| 参数       | 说明                           | 类型     | 默认值 |
| :--------- | :----------------------------- | :------- | :----- |
| width      | 宽度                           | Number   | -      |
| height     | 高度                           | Number   | -      |
| top        | 定位                           | String   | -      |
| bg         | 背景                           | String   | false  |
| prizesData | 奖品数据                       | Object   | false  |
| receive    | 领取按钮是回到页面还是直接领取 | Boolean  | false  |
| onClose    | 关闭按钮的回调                 | Function | false  |

###  注
```javascript
prizesData = {
  _id: "奖品的id",
  type: "奖品的类型",
  image: "奖品图片url",
  name: "奖品名字"
}
```

## useReceive 用法
```javascript
const [ getReceive ] = useReceive({ receiveEnamePrize, receiveObjectPrize })
// 引入useReceive Hooks，调用时传入receiveEnamePrize(优惠券和积分接口)， receiveObjectPrize（实物接口），返回一个处理函数。

const result = await getReceive({ prizeId, type })
// 在用户领取时调用它，传入奖品id以及type(符合PRIZE_TYPE枚举格式)，返回一个promise对象，处理完毕后成功或者用户身份验证失败等会返回对象(message, stest)，如果是上阶段传入的领取接口失败则不返回任何信息。
```