// promise化 淘宝api
// 具体 api参数 ->  https://miniapp.open.taobao.com/doc.htm?docId=117502&docType=1

export function chooseImage() {
  return promisifyMyApi('chooseImage')
}

export function getImageInfo(params) {
  return promisifyMyApi('getImageInfo', params)
};

// 剪切板
export function setClipboard(params) {
  return promisifyMyApi('setClipboard', params)
};


function promisifyMyApi(methodName, params = {}) {
  return new Promise((resolve, reject) => {
    my[methodName]({
      ...params,
      success: res => {
        resolve(res)
      },
      fail: err => {
        reject(err)
      }
    })
  })
}