"use strict";
/**
 * 用户相关方法
 *
 * @format
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var sdk_1 = require("../sdk");
var base_service_1 = require("./base.service");
var db_1 = require("../db");
var utils_1 = require("../utils");
var config_1 = require("../config");
var UserService = /** @class */ (function (_super) {
    __extends(UserService, _super);
    function UserService(context) {
        var _this = _super.call(this, context) || this;
        _this.userdao = new sdk_1.BaseDao(context, db_1.USER_DB_NAME);
        return _this;
    }
    /**
     * @desc 获取当前打开活动的用户详情
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    UserService.prototype.getUserInfo = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, openId, data, activityId, record;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.context, openId = _a.openId, data = _a.data;
                        activityId = data.activityId;
                        return [4 /*yield*/, this.userdao.findOne({ openId: openId, activityId: activityId })];
                    case 1:
                        record = _b.sent();
                        return [2 /*return*/, record];
                }
            });
        });
    };
    /**
     * @desc 根据inviteId获取用户详情
     * @desc 常用于助力分享码为用户openId, 被邀请人打开活动助力时需要获取邀请人的用户详情
     * @param {邀请人的openId} inviteId
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    UserService.prototype.getUserInfoByOpenId = function (inviteId) {
        return __awaiter(this, void 0, void 0, function () {
            var activityId, record;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        activityId = this.context.data.activityId;
                        return [4 /*yield*/, this.userdao.findOne({ openId: inviteId, activityId: activityId })];
                    case 1:
                        record = _a.sent();
                        return [2 /*return*/, record];
                }
            });
        });
    };
    /**
     * @desc 获取是否是会员
     * @param {调用淘宝接口的session} session
     * @returns {isVip: boolean(是否是会员), url: string(入会链接) }
     */
    UserService.prototype.getShopVip = function (session, callbackUrl) {
        if (callbackUrl === void 0) { callbackUrl = ''; }
        return __awaiter(this, void 0, void 0, function () {
            var VIP_MOCK, result, shopUrl, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        VIP_MOCK = config_1.getConfig(this.context).VIP_MOCK;
                        if (VIP_MOCK) {
                            return [2 /*return*/, {
                                    isVip: true
                                }];
                        }
                        result = {
                            result: {
                                member_info: ''
                            }
                        };
                        shopUrl = {
                            result: {
                                result: ''
                            }
                        };
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 4, , 5]);
                        return [4 /*yield*/, sdk_1.TBAPIS.queryVipinfo(this.context, session)];
                    case 2:
                        result = _a.sent();
                        return [4 /*yield*/, sdk_1.TBAPIS.getShopVipUrl(this.context, session, {
                                source: 'isvapp',
                                entrance: 'duiba'
                            }, callbackUrl)];
                    case 3:
                        shopUrl = _a.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        e_1 = _a.sent();
                        console.log(e_1);
                        return [3 /*break*/, 5];
                    case 5:
                        console.log("result, shopUrl", result, shopUrl);
                        return [2 /*return*/, {
                                isVip: !!(result.result && result.result.member_info),
                                url: shopUrl.result && shopUrl.result.result
                            }];
                }
            });
        });
    };
    /**
     * 初始化用户数据
     *
     * @param {IVipInfo} vipInfo
     * @param {IActivityInfo} activityInfo
     * @returns
     * @memberof UserService
     */
    UserService.prototype.initUserData = function (vipInfo, activityInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, openId, data, activityId, isFollow, avatar, inviteId, userNick, today, tasks, attentionStore, beMembership, user;
            var _b, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _a = this.context, openId = _a.openId, data = _a.data;
                        activityId = data.activityId, isFollow = data.isFollow, avatar = data.avatar, inviteId = data.inviteId, userNick = data.userNick;
                        today = utils_1.getToday();
                        console.log("----------" + today + "----------", today);
                        tasks = activityInfo.tasks;
                        attentionStore = tasks.attentionStore, beMembership = tasks.beMembership;
                        user = {
                            activityId: activityId,
                            avatar: avatar,
                            inviteId: inviteId,
                            userNick: userNick,
                            openId: openId,
                            // 待领取次数初始化, 根据需自定义添加
                            remainTimes: {
                                follow: isFollow ? attentionStore.value : 0,
                                member: vipInfo.isVip ? beMembership.value : 0
                            },
                            member: {
                                flag: !!vipInfo.isVip
                            },
                            follow: {
                                flag: !!isFollow
                            },
                            login: (_b = {},
                                _b[today] = 1,
                                _b),
                            taskInfo: (_c = {},
                                _c[today] = {},
                                _c),
                            createTime: Date.now(),
                            createDay: today,
                            updateTime: Date.now()
                        };
                        return [4 /*yield*/, this.userdao.insertOne(user)];
                    case 1: return [2 /*return*/, _d.sent()];
                }
            });
        });
    };
    UserService.prototype.updateUserData = function (vipInfo, userInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var data, isFollow, followBefore, followNow, today, isNewVip;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        data = this.context.data;
                        isFollow = data.isFollow;
                        followBefore = userInfo.follow.flag;
                        followNow = isFollow;
                        if (!followBefore && followNow && !userInfo.follow.newFollow) {
                            userInfo.follow.newFollow = true;
                            userInfo.follow.followTime = userInfo.follow.followTime || Date.now();
                        }
                        today = utils_1.getToday();
                        isNewVip = this.checkNewVipStatus(userInfo, vipInfo);
                        if (isNewVip && !userInfo.member.newMember) {
                            userInfo.member.newMember = true;
                            userInfo.member.bememberTime = userInfo.member.bememberTime || Date.now();
                        }
                        // 添加登录次数
                        userInfo['login'][today] = userInfo['login'][today] ? userInfo['login'][today] + 1 : 1;
                        return [4 /*yield*/, this.updateUser(userInfo._id, {
                                $set: {
                                    follow: userInfo.follow,
                                    login: userInfo['login'],
                                    member: userInfo.member
                                }
                            })];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * @desc 更新用户表
     * @param {用户的主键id} _id
     * @param {更新的对象} document
     * @returns 若更新成功，返回为1； 若更新失败，返回为 0 或系统直接报错
     */
    UserService.prototype.updateUser = function (_id, projection) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        console.log(projection);
                        if (projection['$set']) {
                            projection['$set'].updateTime = Date.now();
                        }
                        return [4 /*yield*/, this.userdao.update({ _id: _id }, projection)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     * @desc 根据用户主键id查找用户详情
     * @param {用户的主键id} _id
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    UserService.prototype.getUserInfoById = function (_id) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.userdao.findOne({ _id: _id })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     *判断是否新会员
     *
     * @param {IUserInfo} userInfo
     * @param {IVipInfo} vipInfo
     * @returns {boolean}
     * @memberof UserService
     */
    UserService.prototype.checkNewVipStatus = function (userInfo, vipInfo) {
        var flag = userInfo.member.flag;
        var isVip = vipInfo.isVip;
        return !flag && isVip;
    };
    return UserService;
}(base_service_1.default));
exports.default = UserService;
//# sourceMappingURL=user.service.js.map