"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var decorator_1 = require("../decorator");
var sdk_1 = require("../sdk");
var service_1 = require("../service");
var constants_1 = require("../constants");
var BaseController = /** @class */ (function () {
    function BaseController() {
    }
    /**
     *  保存授权信息
     */
    BaseController.prototype.sellerSave = function (context, _a, _b) {
        var sellerService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var openId, accessToken, appKey, userNick, appOwnerOpenId, isPrimaryAccount, primaryUserNick, sellerInfo, hasSellerInfo, result;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        openId = context.openId, accessToken = context.accessToken, appKey = context.appKey, userNick = context.userNick, appOwnerOpenId = context.appOwnerOpenId;
                        isPrimaryAccount = userNick.indexOf(':') === -1;
                        console.log(userNick, isPrimaryAccount, 'userNick------');
                        if (!!isPrimaryAccount) return [3 /*break*/, 2];
                        primaryUserNick = userNick.split(':')[0];
                        return [4 /*yield*/, sellerService.getSellerInfoByUserNick(primaryUserNick)];
                    case 1:
                        sellerInfo = _c.sent();
                        if (sellerInfo) {
                            accessToken = sellerInfo.accessToken;
                        }
                        _c.label = 2;
                    case 2: return [4 /*yield*/, sellerService.findSellerInfo(openId)];
                    case 3:
                        hasSellerInfo = _c.sent();
                        if (!hasSellerInfo) return [3 /*break*/, 5];
                        return [4 /*yield*/, sellerService.updateSellerInfo(openId, { accessToken: accessToken })];
                    case 4:
                        _c.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success(true)];
                    case 5: return [4 /*yield*/, sellerService.saveSellerInfo({
                            accessToken: accessToken,
                            openId: openId,
                            appKey: appKey,
                            userNick: userNick,
                            appOwnerOpenId: appOwnerOpenId
                        })];
                    case 6:
                        result = _c.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success(result)];
                }
            });
        });
    };
    BaseController.prototype.sellerSaasSave = function (context, _a, _b) {
        var sellerService = _b[0], taobaoTopService = _b[1], InstanceService = _b[2];
        return __awaiter(this, void 0, void 0, function () {
            var openId, accessToken, appKey, userNick, appOwnerOpenId, consumeMiniAppId, primaryAccountNick, isPrimaryAccount, primaryOpenId, shopId, userNickArr, sellerInfo, hasResult, subInfo, shopInfoResult, instanceOldInfo, instanceInfo, app_id, app_version, onlineInstance, clients, app_id, template_id, updateInfo, updateInstanceInfo, onlineInstance;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        openId = context.openId, accessToken = context.accessToken, appKey = context.appKey, userNick = context.userNick, appOwnerOpenId = context.appOwnerOpenId, consumeMiniAppId = context.consumeMiniAppId;
                        primaryAccountNick = userNick || 'duiba2';
                        isPrimaryAccount = true;
                        primaryOpenId = openId;
                        shopId = '';
                        if (!(userNick && ~userNick.indexOf(':'))) return [3 /*break*/, 2];
                        userNickArr = userNick.split(':');
                        isPrimaryAccount = false;
                        primaryAccountNick = userNickArr[0];
                        if (!!isPrimaryAccount) return [3 /*break*/, 2];
                        return [4 /*yield*/, sellerService.getSellerInfoByUserNick(primaryAccountNick)];
                    case 1:
                        sellerInfo = _c.sent();
                        if (sellerInfo) {
                            accessToken = sellerInfo.accessToken;
                            primaryOpenId = sellerInfo.openId;
                            shopId = sellerInfo.shopId;
                        }
                        else {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '请用主账号进入后台进行授权')];
                        }
                        _c.label = 2;
                    case 2: return [4 /*yield*/, sellerService.findSellerInfo(openId)];
                    case 3:
                        hasResult = _c.sent();
                        return [4 /*yield*/, taobaoTopService.getSubRelationship(primaryAccountNick)];
                    case 4:
                        subInfo = _c.sent();
                        return [4 /*yield*/, taobaoTopService.getShopId()];
                    case 5:
                        shopInfoResult = _c.sent();
                        if (!(hasResult && hasResult[0])) return [3 /*break*/, 8];
                        return [4 /*yield*/, sellerService.updateSellerInfo(openId, {
                                accessToken: accessToken
                            })];
                    case 6:
                        _c.sent();
                        return [4 /*yield*/, InstanceService.updateInstanceInfo(openId, {
                                accessToken: accessToken
                            })
                            // return resultsModel.success({ deadline: subInfo.deadline || "" });
                        ];
                    case 7:
                        _c.sent();
                        return [3 /*break*/, 10];
                    case 8:
                        if (!shopInfoResult.success) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '获取淘宝店铺信息失败')];
                        }
                        return [4 /*yield*/, sellerService.saveSellerInfo({
                                accessToken: accessToken,
                                openId: openId,
                                appKey: appKey,
                                // @ts-ignore
                                shopId: shopInfoResult.data.sid,
                                userNick: userNick,
                                appOwnerOpenId: appOwnerOpenId
                            })
                            // return resultsModel.success({ deadline: subInfo.deadline || "" });
                        ];
                    case 9:
                        _c.sent();
                        _c.label = 10;
                    case 10: return [4 /*yield*/, InstanceService.getMiniAppInstanceInfoByNick(primaryAccountNick)];
                    case 11:
                        instanceOldInfo = _c.sent();
                        if (!!instanceOldInfo) return [3 /*break*/, 17];
                        if (!isPrimaryAccount) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '请用主账号进入后台进行授权')];
                        }
                        return [4 /*yield*/, taobaoTopService.getTemplateInstantiate()];
                    case 12:
                        instanceInfo = _c.sent();
                        app_id = instanceInfo.app_id, app_version = instanceInfo.app_version;
                        if (!instanceInfo) return [3 /*break*/, 15];
                        return [4 /*yield*/, taobaoTopService.pushOnlineInstance({
                                app_id: app_id,
                                app_version: app_version
                            })];
                    case 13:
                        onlineInstance = _c.sent();
                        return [4 /*yield*/, InstanceService.saveInstanceInfo(__assign(__assign(__assign(__assign({}, instanceInfo), { clients: onlineInstance.online_results.miniapp_instance_app_online_dto.reduce(function (s, v) {
                                    return (s += v.client + ',');
                                }, '') }), onlineInstance.app_info), { accessToken: accessToken, template_version: constants_1.TEMPLATE_INFO.template_version, template_id: constants_1.TEMPLATE_INFO.template_id, openId: openId,
                                appKey: appKey,
                                consumeMiniAppId: consumeMiniAppId, 
                                // @ts-ignore
                                shopId: shopInfoResult.data.sid, userNick: userNick,
                                appOwnerOpenId: appOwnerOpenId }))];
                    case 14:
                        _c.sent();
                        return [3 /*break*/, 16];
                    case 15:
                        console.log('实例化信息获取失败');
                        _c.label = 16;
                    case 16: return [3 /*break*/, 24];
                    case 17:
                        if (!(constants_1.TEMPLATE_INFO.template_version !== instanceOldInfo.template_version)) return [3 /*break*/, 21];
                        clients = instanceOldInfo.clients, app_id = instanceOldInfo.app_id, template_id = instanceOldInfo.template_id;
                        updateInfo = {
                            clients: clients,
                            app_id: app_id,
                            template_id: template_id,
                            ext_json: {
                                name: 'online'
                            },
                            template_version: constants_1.TEMPLATE_INFO.template_version
                        };
                        return [4 /*yield*/, taobaoTopService.updateMiniInstance(updateInfo)];
                    case 18:
                        updateInstanceInfo = _c.sent();
                        return [4 /*yield*/, taobaoTopService.pushOnlineInstance({
                                app_id: updateInstanceInfo.app_id,
                                app_version: updateInstanceInfo.app_version
                            })];
                    case 19:
                        onlineInstance = _c.sent();
                        return [4 /*yield*/, InstanceService.updateInstanceInfo(openId, __assign(__assign({ template_version: constants_1.TEMPLATE_INFO.template_version }, onlineInstance.app_info), { app_version: updateInstanceInfo.app_version, pre_view_url: updateInstanceInfo.pre_view_url }))];
                    case 20:
                        _c.sent();
                        _c.label = 21;
                    case 21: return [4 /*yield*/, InstanceService.updateInstanceInfo(openId, {
                            // @ts-ignore
                            shopId: shopInfoResult.data.sid
                        })];
                    case 22:
                        _c.sent();
                        return [4 /*yield*/, InstanceService.updateInstanceInfo(primaryOpenId, {
                                // @ts-ignore
                                shopId: shopInfoResult.data.sid
                            })];
                    case 23:
                        _c.sent();
                        _c.label = 24;
                    case 24: return [2 /*return*/, sdk_1.resultsModel.success({ deadline: subInfo.deadline || '' })];
                }
            });
        });
    };
    __decorate([
        decorator_1.services([service_1.SellerService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "sellerSave", null);
    __decorate([
        decorator_1.services([service_1.SellerService, service_1.TaobaoTopService, service_1.InstanceService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "sellerSaasSave", null);
    return BaseController;
}());
exports.default = BaseController;
//# sourceMappingURL=seller.controller.js.map