/** @format */

import * as dayjs from 'dayjs'
import { getEndTimestamp, getStartTimestamp, transformBeijingDate } from '../../sdk'

const EIGHT_HOURS = 8 * 60 * 60 * 1000

/**
 *  格式化时间 统一处理8小时时差问题
 *  YYYY-MM-DDTHH:mm:ss
 *
 *  formatDate().format('YYYY-MM-DD HH:mm:ss')
 *  formatDate('2021/01/21').getStartTimestamp()
 *  formatDate('2021/01/21').getEndTimestamp()
 *  formatDate('2021/01/21').getTimestamp()
 * @export
 * @param {(string | number)} date
 * @return {
 *  format 格式化时间
 *  getTimestamp  时间戳
 *  getStartTimestamp 某天开始的时间戳
 *  getEndTimestamp 某天结束的时间戳
 *  getYear 获取年份
 *  getMonth 获取月份
 *  getDay 获取天
 *  getHour 获取小时
 *  getMinute 获取分钟
 *  geSecond 获取秒数
 *  getMillisecond 获取毫秒
 * }
 */
export function formatDate(date: string | number = Date.now()) {
  const beijingDate = typeof date === 'string' ? new Date(date) : transformBeijingDate(date)
  return {
    format: (template = 'YYYY-MM-DD') => dayjs(beijingDate).format(template),
    getTimestamp: () => (typeof date === 'number' ? date : dayjs(date).valueOf() - EIGHT_HOURS),
    getStartTimestamp: () => getStartTimestamp(dayjs(beijingDate).format('YYYY/MM/DD')),
    getEndTimestamp: () => getEndTimestamp(dayjs(beijingDate).format('YYYY/MM/DD')),
    getYear: () => dayjs(beijingDate).get('year'),
    getMonth: () => dayjs(beijingDate).get('month'),
    getDay: () => dayjs(beijingDate).get('day'),
    getHour: () => dayjs(beijingDate).get('hour'),
    getMinute: () => dayjs(beijingDate).get('minute'),
    geSecond: () => dayjs(beijingDate).get('second'),
    getMillisecond: () => dayjs(beijingDate).get('millisecond')
  }
}
