/** @format */

const gulp = require('gulp')
const rename = require('gulp-rename')
const nunjucksRender = require('gulp-nunjucks-render')
const prettier = require('gulp-prettier')
const codeGenerate = require('./generate')

var jsScript = 'node'
if (process.env.npm_config_argv !== undefined && process.env.npm_config_argv.indexOf('debug') > 0) {
  jsScript = 'node debug'
}

const ServerFullPath = '../src'

const prettierConfig = {
  printWidth: 120,
  semi: false,
  singleQuote: true,
  trailingComma: 'none',
  bracketSpacing: true,
  arrowParens: 'avoid',
  insertPragma: true,
  tabWidth: 2,
  useTabs: false
}

const nunjucksRenderConfig = {
  path: 'templates',
  ext: '.ts',
  manageEnv: environment => {
    environment.addFilter('firstToCapital', str => {
      return str.charAt(0).toUpperCase() + str.slice(1)
    })
    environment.addFilter('groupByTypeAndService', value => {
      const res = {}
      for (let main of value) {
        if (!res[main.type]) {
          res[main.type] = {}
        }
        res[main.type][main.service] = true
      }
      return res
    })
  },
  ServerFullPath
}

gulp.task('build', function () {
  require('events').EventEmitter.defaultMaxListeners = 0
  return codeGenerate.run(gulp, nunjucksRender, rename, nunjucksRenderConfig)
})

console.log(nunjucksRenderConfig.ServerFullPath + '/**/*.ts')
gulp.task('format', () => {
  return gulp
    .src(nunjucksRenderConfig.ServerFullPath + '/**/*.ts')
    .pipe(prettier(prettierConfig))
    .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath + '/'))
})

gulp.task('code', gulp.series('build', 'format'))
