
import { PRIZE_CONFIG, DRAW_STATUS, PRIZE_TYPE, BENEFIT_TYPE } from '@/config/myPrize.config'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import config from '@/config/config'
import { receiveEnamePrize, receiveObjectPrize, receiveMemberEname } from '@/utils/util'
import tbccTs from 'tbcc-sdk-ts'

const { commonToast, navigateToOutside, setClipboard } = tbccTs.tb


/**
 * @description 领取奖品
 * @param {*} item 
 * @param {*} vipCallback 入会回调 
 * @param {*} updateCallback 奖品页面更新列表回调 
 * 
 */
import { getApp, setTabBarBadge } from '@tarojs/taro'

export const receivePrize = async(item, callbackObj={vipCallback:()=>{},updateCallback:()=>{},closeCallback:()=>{}}) => {
    const app = getApp();
    const { activityId } = app
    const { type, drawStatus, useUrl = '', id, _id, ename = '', benefitType } = item

    const successMsg = '领取成功'
    const errorMsg = '请求失败'

    if(type === PRIZE_TYPE.CREDITS || (type === PRIZE_TYPE.ENAME && benefitType === BENEFIT_TYPE.MEMBER)) {
        const isVip = await checkIsMember()
        if(!isVip) {
          commonToast('需加入会员才能领取成功哦', 2000, ()=>{callbackObj.vipCallback && callbackObj.vipCallback()})
          return;
        }
    }

    const receiveFn = {
        // 'update': async () => fetchMyPriceList(),
        [PRIZE_TYPE.ENAME]: async () => {
          if(benefitType === BENEFIT_TYPE.MEMBER) {
           await receiveMemberEname({params: { sellerId: config.sellerId, ename, id }, successMsg, errorMsg })
          }else {
            await receiveEnamePrize({params: { activityId, id }, successMsg, errorMsg })
          }
        },
        [PRIZE_TYPE.OBJECT]: async () => {
          await receiveObjectPrize({params: { activityId, id }, successMsg, errorMsg })
        },
        [PRIZE_TYPE.CREDITS]: async () => {
          await receiveEnamePrize({params: { activityId, id }, successMsg, errorMsg })
        }
      }
     await receiveFn[type]()
    //  更新奖品列表
     callbackObj.updateCallback && callbackObj.updateCallback();

     callbackObj.closeCallback && callbackObj.closeCallback();
}