import React, { useState, useEffect,useRef, useMemo, useCallback } from "react";
import { View, Image, Text, Swiper, SwiperItem } from "@tarojs/components";

import './SwiperView.less'
import Taro,{showToast,redirectTo,navigateTo} from '@tarojs/taro'

export const EASING_WAYS = {
    'DEFAULT':'default',
    'LINEAR':'linear',
    'EASEIN':'easeInCubic',
    'EASEOUT':'easeOutCubic',
    'EASEINOUT':'easeInOutCubic'
}
const SwiperView = (props) => {
    /**
     * @description swiperList
     * {image,content,hasBtn}
     */
  const {
    swiperList=[], 
    easingFunction=`${EASING_WAYS.LINEAR}`,
    circular=false,
    autoplay=false,
    vertical=false,
    duration=1000,
    interval=1500,
    disableTouch=false,
    swiperGroup={width:300,height:300,overflow:'visible'},
    swiperContent={width:250,height:300,backgroundColor:'#fff',backgroundImage:'',borderRadius:25},
    imgContent={width:200,height:200},
    textContent={width:200,height:60},
    showLeftRightBtn=true,
    
  } = props;

  const [currentIndex, setCurrentIndex] = useState(1);

  const indexref = useRef(0)

  // const index = useMemo(()=>{
  //   return currentIndex;
  // },currentIndex)

  

  /**
   * @description onchange事件
   * @param {*} e 
   */
  const swiperChange = e => {
    console.log("e", e);
    console.log('swiperChange-----currentindex',currentIndex,indexref.current,e.detail.current);
    setCurrentIndex(e.detail.current);
  };
  
  /**
   * @description 入场/出场动画
   * @param {*} index 数组索引值
   * @returns 返回类名
   */
  const useCustomAni =((i) => {
    return `${((currentIndex < i && ((i !== swiperList.length - 1)||currentIndex!==0)) || ((currentIndex === swiperList.length - 1) && i == 0 ))  
              ? 'item_right' 
              : 
              (((currentIndex > i && (i !== 0 || currentIndex !== swiperList.length - 1)) || (currentIndex !== 0 && i !== swiperList.length - 1))  ? 'item_left' : 'item_middle')
            }`
  }) 

  /**
   * @description 获取当前卡片详情之类
   */
  const getCurrentDetail = (item) => {
    showToast({
      title:'111'
    })
  }

  const motionType = {
    LEFT:"LEFT",
    RIGHT:"RIGHT"
  }

  /**
   * @description 
   */

  const turnRound = ((type) => {
    const motion = {
      [motionType.LEFT]:()=>{
        setTimeout(() => {
          // setCurrentIndex((indexref.current==0) ? (swiperList.length - 1) : (indexref.current - 1))
          // indexref.current = (indexref.current==0) ? (swiperList.length - 1) : (indexref.current - 1)
          // console.log('left----',currentIndex,indexref.current);

          if(currentIndex >= 1){
            setCurrentIndex(currentIndex - 1)
          }
          
        }, 0);
      },
      [motionType.RIGHT]:()=>{
        setTimeout(() => {
          // setCurrentIndex((indexref.current == (swiperList.length - 1)) ? 0 : (indexref.current + 1))
          // indexref.current = (indexref.current == (swiperList.length - 1)) ? 0 : (indexref.current + 1)
          // console.log('right----',currentIndex,indexref.current);
          if(currentIndex < swiperList.length - 1){
            setCurrentIndex(currentIndex + 1)
          }

        }, 0);
      }
    }
    motion[type]();
  }) 

  useEffect(()=>{
    console.log('cur----',currentIndex);
  },[currentIndex])

  return (
    <View className="contain">
      <View className='left_btn' onTap={()=>turnRound('LEFT')}>&lt;&lt;</View>

      <View 
        className="scroll_container"
        style={{
          width:`${700/100}rem`,
          overflow:'hidden'
        }}
      >
        <Swiper
          className="swiper_group"
          current={currentIndex}
          easingFunction={easingFunction}
          onChange={swiperChange}
          circular={circular}
          vertical={vertical}
          autoplay={autoplay}
          duration={duration}
          interval={interval}
          disableTouch={disableTouch}
          style={{
            width:`${swiperGroup.width/100}rem`,
            height:`${swiperGroup.height/100}rem`,
            overflow:`${swiperGroup.overflow}`
          }}
        >
          {swiperList.length &&
            swiperList.map((item, i) => (
              <SwiperItem>
                <View
                  className={`scroll_item ${i === currentIndex ? "current_item" : ""} ${useCustomAni(i)}`}
                  style={{
                    width:`${swiperContent.width/100}rem`,
                    height:`${swiperContent.height/100}rem`,
                    backgroundColor:`${ swiperContent.backgroundColor}`,
                    backgroundImage:`${ swiperContent.backgroundImage}`,
                    borderRadius:`${swiperContent.borderRadius/100}rem`
                  }}
                  onTap={()=>getCurrentDetail(item)}
                >
                  {/* {i === currentIndex &&  (
                    <Image
                      className="checkPic"
                      src="https://yun.dui88.com/tebuXinYuan/checkGoods.png"
                    ></Image>
                  )} */}
                  <View 
                    className="item_img_content"
                  >
                    {/* 单个swiper主要内容 */}
                    <Image 
                      className="img" 
                      style={{
                        width:`${imgContent.width/100}rem`,
                        height:`${imgContent.height/100}rem`
                      }} 
                      src={item.image}></Image>
                    {
                      item?.content &&
                      <View 
                        className='text_content'
                        style={{
                          width:`${textContent.width/100}rem`,
                          height:`${textContent.height/100}rem`,
                        }}
                      >
                        <View className='text' >{item.content}</View>
                      </View>
                    }
                  </View>
                </View>
              </SwiperItem>
            ))}
        </Swiper>
        
      </View>
        <View className='right_btn' onTap={()=>turnRound('RIGHT')}>&gt;&gt;</View>
    </View>
  );
};
export default SwiperView;
