import React, { useState, useEffect, useRef } from 'react'
import { View, Text } from '@tarojs/components'
import { useDidShow, useDidHide } from '@tarojs/taro'
import tbcc from 'tbcc-sdk-ts'
import './CountDown.less'
const { getServerTime } = tbcc.tb

export default function CountDown(props) {
  const { endTime, startTime, onUpdate, type = 1, color = '#000', bgColor = 'transparent', fontSize = '26rpx', padding = '0' } = props
  const [countDown, setCountDown] = useState(type === 1 ? ['00', ':', '00', ':', '00'] : ['00', '天', '00', '时', '00', '分', '00', '秒'])
  const [nowTime, setNowTime] = useState(startTime || Date.now())
  const countTimer = useRef(null)
  const isAccessRender = useRef(false)

  useEffect(() => {
    countTimeFn()
    return () => clearInterval(countTimer.current)
  }, [endTime, nowTime])

  useDidShow(() => {
    if(isAccessRender.current) {
      setNowTime(startTime || Date.now())
    }
    isAccessRender.current = true
  })

  const countTimeFn = async () => {
    const _nowTime = await getServerTime()

    let diffTime = endTime - (startTime || _nowTime)
    countTimer.current = setInterval(() => {
      if (diffTime > 1000) {
        let day = Math.floor(diffTime / (3600 * 1000) / 24)
        let hour = Math.floor((diffTime / 1000 / 3600) % 24)
        let minute = Math.floor((diffTime / 1000 / 60) % 60)
        let second = Math.floor(diffTime / 1000 % 60)
        day = day < 10 ? '0' + day : day
        hour = hour < 10 ? '0' + hour : hour
        minute = minute < 10 ? '0' + minute : minute
        second = second < 10 ? '0' + second : second
        setCountDown(type === 1 ? [hour, ':', minute, ':', second] : [day, '天', hour, '时', minute, '分', second, '秒'])
        diffTime -= 1000
      } else {
        setCountDown(type === 1 ? ['00', ':', '00', ':', '00'] : ['00', '天', '00', '时', '00', '分', '00', '秒'])
        clearInterval(countTimer.current)
        onUpdate && onUpdate()
      }
    }, 1000)
  }

  return (
    <View className="count-down">
      {
        countDown.map((item, i) => {
          return (
            <Text className="count-down-time" key={i} style={{ backgroundColor: item !== ':' ? bgColor : 'transparent', fontSize, color, padding }}>{item}</Text>
          )
        })
      }
    </View>
  )
}