import React, { useState } from 'react'
import Overlay from '../Overlay/Overlay'
import styles from './modal.module.less'
import classnames from 'classnames'
import {View,Text} from '@tarojs/components'
export default function Modal(props) {
  const { closePostion = 'top-right', onClose = () => { }, top = '40%', hideCloseButton = false, closeOnClickOverlay = false, closePos = { right: 0, top: -30 } } = props

  const closeBtnClass = classnames(styles.closeButton, {
    [`${styles.closeButton_bottom}`]: closePostion === 'bottom',
    [`${styles.closeButton_right_top}`]: closePostion === 'top-right'
  })

  const [ isShowAnimateOut, setShowAnimate ] = useState(false)

  const modalClass = classnames(styles.modal, {
    'animate-fade-out': isShowAnimateOut
  })

  const onCloseModal = () => {
    setShowAnimate(true)
    setTimeout(() => {
      setShowAnimate(false)
      onClose()
    }, 350)
  }

  const onClickOverlay = () => {
    closeOnClickOverlay && onCloseModal()
  }

  return (
    <View className={modalClass}>
      <Overlay onClick={() => onClickOverlay()} />
      <View className={`${styles.content} animate-zoom-in`} style={{ top }}>
        {props.children}
        {!hideCloseButton && <View className={closeBtnClass} onClick={() => onClose()} style={{ top: closePos.top / 100 + 'rem', right: closePos.right / 100 + 'rem' }} />}
      </View>

    </View>
  )
}
