import moment from "moment";
import schema from "async-validator";
import { descriptor, formatValidator } from "./validate";
import { getActivityDetail, saveActivityInfo, generateRule } from "/api";
import { addFloat } from "/utils/helper";

const THANKS_TYPE = 5;
const STOCK_LIMIT = 1;
const STOCK_NO_LIMIT = 2;
var validator = new schema(descriptor);

Component({
  data: {
    labelCol: { fixedSpan: 5 },
    id: "",
    title: "",
    subtitle: "",
    startTime: "",
    endTime: "",
    timeRange: [],
    rule: "",
    prizeInfoList: [
      {
        ename: "",
        id: "",
        stock: "",
        type: 1,
        image: "",
        credits: "",
        name: "",
        switchStock: STOCK_NO_LIMIT,
        useStock: 0,
        rank: "1",
      },
      {
        ename: "",
        id: "",
        stock: "",
        type: 1,
        image: "",
        credits: "",
        name: "",
        switchStock: STOCK_NO_LIMIT,
        useStock: 0,
        rank: "2",
      },
      {
        ename: "",
        id: "",
        stock: "",
        type: 1,
        image: "",
        credits: "",
        name: "",
        switchStock: STOCK_NO_LIMIT,
        useStock: 0,
        rank: "3",
      },
    ],
    commandTitle: "",
    commandImg: "",
    logoImg: "",
    beenInvitedText: "",
    taskList: [
      // {
      //   type: "member",//会员
      //   value: 20,//完成任务获得值
      // },
      // {
      //   type: "follow",
      //   value: 20,
      // },
      // {
      //   type: "sign",
      //   value: 20,
      // },
      // {
      //   type: "exchangeCredits",
      //   value: 20,
      //   times: 1,
      // },
      // {
      //   type: "invites",
      //   title: "标题",//任务标题
      //   taskRateType: 1,//任务频率类型
      //   times: 3,//任务为每日限次次数值
      //   value: 30,
      // },
      // {
      //   type: "orderGoods",
      //   title: "标题",
      //   taskRateType: 2,
      //   times: 3,
      //   value: 90,
      //   itemIds: "111,222,333",//商品类型任务商品id
      // },
      // {
      //   type: "browseGoods",
      //   title: "标题",
      //   taskRateType: 3,
      //   times: 3,
      //   value: 90,
      //   itemIds: "111,222,333",
      // },
      // {
      //   type: "jumpLink",
      //   title: "标题",
      //   taskRateType: 3,
      //   link: "http://www.taobao.com",//跳转链接
      //   times: 3,
      //   value: 90,
      // },
      // {
      //   type: "collectGoods",
      //   title: "标题",
      //   taskRateType: 1,
      //   times: 3,
      //   value: 90,
      //   itemIds: "111,222,333",
      // }
    ],

    taskMap: {
      // follow: {
      //   value: '',
      // },
      member: {
        value: "",
        checked: false,
      },
      // sign: {
      //   value: ''
      // },
      // exchangeCredits: {
      //   value: '',
      //   times: '',
      // },
      invites: {
        title: "", // 任务标题
        taskRateType: 1, // 任务频率类型
        times: 3, // 任务为每日限次次数值
        value: "", // 任务奖励
        checked: false,
      },
      browseGoods: {
        title: "寻宝屋商品",
        taskRateType: 1,
        times: 3,
        value: "",
        link: "",
        itemIds: "",
        checked: true,
      },
      // collectGoods: {
      //   title: "",
      //   taskRateType: 1,
      //   times: 3,
      //   value: '90',
      //   itemIds: "",
      // },
      jumpLink: {
        title: "",
        taskRateType: 3,
        link: "", //跳转链接
        times: 3,
        value: "",
        checked: false,
      },
    },
    image: "",
    isEnd: false,
    isStart: false,
    originalStartTime: "",
    prizeDialogData: {},
    formState: formatValidator(descriptor),
    isPostParams: true,
  },
  props: {},
  didMount() {
    const { id } = this.$page.$router.params;
    if (id) {
      this.getActivityInfo(id);
    }
  },
  methods: {
    // 获取id活动信息
    async getActivityInfo(activityId) {
      try {
        const { success, data, message } = await getActivityDetail({
          activityId,
        });
        if (!success) {
          this.showFailToast(message);
          return;
        }

        let { prizeInfoList, ...rest } = data;

        this.setData({
          ...rest,
          timeRange: [+rest.startTime, +rest.endTime],
          originalStartTime: +rest.startTime,
          isStart: +rest.startTime < Date.now(),
          isEnd: +rest.endTime < Date.now(),
          prizeInfoList:
            prizeInfoList && prizeInfoList.length > 0
              ? prizeInfoList
              : this.data.prizeInfoList,
          taskList: rest.taskList,
          taskMap: this.formatTaskListToMap(rest.taskList),
        });
      } catch (error) {
        console.log(error, "err");
      }
    },
    onChange(e) {
      const { value } = e.detail;
      const { name } = e.target.dataset;
      this.setData({
        [name]: value,
      });
    },
    onRuleChange(rule) {
      this.setData({
        rule,
      });
    },
    setDataByKey(name, val) {
      const keys = name.split(".");
      if (keys.length === 1) {
        this.setData({
          [keys[0]]: val,
        });
      }
      if (keys.length === 2) {
        let targetKey = this.data[keys[0]];
        targetKey[keys[1]] = val;
        let newVal = Object.assign({}, targetKey);
        this.setData({
          [keys[0]]: newVal,
        });
      }
      if (keys.length === 3) {
        let targetKey = this.data[keys[0]];
        targetKey[keys[1]][keys[2]] = val;
        let newVal = Object.assign({}, targetKey);
        this.setData({
          [keys[0]]: newVal,
        });
      }
    },
    onTaskInputChange(e) {
      const { name } = e.target.dataset;
      const { value } = e.detail;
      this.setDataByKey(name, value);
    },
    onCheckChange(e) {
      const { name } = e.target.dataset;
      const { value } = e.detail;
      this.setDataByKey(name, value);
    },
    onTaskChange(data, key) {
      console.log(data, key);
      this.setDataByKey(key, data);
    },
    onImageChange(image) {
      console.log("image", image);
      this.setData({
        image,
      });
    },
    onTimeChange(timeRange, error) {
      const { formState } = this.data;

      this.setData({
        timeRange,
        startTime: timeRange[0],
        endTime: timeRange[1],
        formState: {
          ...formState,
          timeRange: {
            status: error ? "error" : "success",
            message: error || "",
          },
        },
      });
    },
    onPrizeListChange(prizeInfoList) {
      console.log("prizeInfoList", prizeInfoList);
      this.setData({
        prizeInfoList,
      });
    },
    validateForm(data, target) {
      const _this = this;
      return new Promise((resolve, reject) => {
        validator.validate(data, (errors, fields) => {
          console.log("errors", errors);
          console.log("fields", fields);
          const { formState } = _this.data;
          _this.setFormTips(formState, errors, target);
          if (errors) {
            resolve(false);
          } else {
            resolve(true);
          }

          // validation passed
        });
      });
    },
    setFormTips(formState, errors, target) {
      errors = errors || [];
      let newValidator = {};
      Object.keys(formState).forEach((key) => {
        let error =
          errors.filter((v) =>
            target ? v.field === target && v.field === key : v.field === key
          ).length && errors.filter((v) => v.field === key)[0];

        newValidator[key] = {
          status: error ? "error" : "success",
          message: error ? error.message : "",
        };
      });

      console.log("newValidator", newValidator);

      this.setData({
        formState: newValidator,
      });
    },
    // 提交信息
    async onSubmit() {
      const isValidForm = await this.validateForm(this.data);

      // console.log(this.formatActivityParams(this.data))

      if (!isValidForm) return;

      console.log("成功");

      const params = this.formatActivityParams(this.data);

      console.log(params);

      if (this.data.isPostParams) {
        this.setData({
          isPostParams: false,
        });
        const { success, message } = await saveActivityInfo(params);
        if (success) {
          this.backList();
          this.setData({
            isPostParams: true,
          });
        } else {
          this.showFailToast(message);
        }
      }
    },
    showFailToast(text) {
      my.showToast({
        type: "fail",
        content: text,
      });
    },
    // 格式化参数
    formatActivityParams(params) {
      const {
        id = "",
        activityId = "",
        startTime,
        endTime,
        rule,
        title,
        subtitle,
        logoImg,
        prizeInfoList,
        taskList,
        taskMap,
        commandTitle,
        commandImg,
        beenInvitedText,
      } = params;

      return {
        id,
        activityId,
        title,
        subtitle,
        logoImg,
        startTime: new Date(startTime).getTime(),
        endTime: new Date(endTime).getTime(),
        rule,
        prizeInfoList: this.formatPobalityPrizeList(prizeInfoList),
        taskList: this.formatTaskMapToList(taskMap),
        commandTitle,
        commandImg,
        beenInvitedText,
      };
    },
    // taskMap转化taskList
    formatTaskMapToList(taskMap) {
      let list = [];
      Object.keys(taskMap).forEach((type) => {
        if (!taskMap[type].checked) return;
        let task = {
          ...taskMap[type],
          type,
        };
        list.push(task);
      });
      return list;
    },
    // taskList转化taskMap
    formatTaskListToMap(taskList = []) {
      let taskMap = {};
      taskList.forEach((task) => {
        taskMap[task["type"]] = task;
      });
      return taskMap;
    },
    // 补足谢谢参与类型
    formatPobalityPrizeList(prizeInfoList = []) {
      let totalPercent = prizeInfoList.reduce((total, next) => {
        return (total = addFloat(total, +next.probability));
      }, 0);
      // 排名类型不含谢谢参与
      if (prizeInfoList[0].rank) return prizeInfoList;
      let prizeInfoListCopy = prizeInfoList
        .concat()
        .map((v, index) => ({ ...v, level: index }));

      if (totalPercent < 100) {
        let thanksType = {
          type: THANKS_TYPE,
          name: "谢谢参与",
          probability: 100 - totalPercent,
        };
        prizeInfoListCopy.push(thanksType);
      }
      return prizeInfoListCopy;
    },
    cancelEdit() {
      this.backList();
    },
    onInputChange(e) {
      let {
        detail: { value },
        currentTarget: { dataset },
      } = e;
      let { name } = dataset;
      this.setData({ [name]: value });
    },
    onChangeByDataName(val, dataName) {
      this.setDataByKey(dataName, val);
    },
    // 选择奖品弹窗
    handlerShowPrize(evt) {
      const { prizeInfoList } = this.data;
      let { name } = evt.target.dataset;
      if (name === "edit") {
        this.setData({
          showPrize: true,
          prizeDialogData: evt.target.dataset.x,
          prizeDialogEdit: true,
          hasEditPrize: true,
        });
      } else {
        if (prizeInfoList.length >= 20) {
          this.showFailToast("最多创建20个奖励配置");
          return false;
        }
        this.setData({
          showPrize: true,
          prizeDialogData: {},
          prizeDialogEdit: false,
          hasEditPrize: false,
        });
      }
    },
    //生成规则
    generateRule() {
      const { title, startTime, endTime, prizeInfoList } = this.data;
      if (title && startTime && endTime && prizeInfoList.length) {
        let bool = true;
        prizeInfoList.forEach((i) => {
          if (!i.image || !i.name) {
            bool = false;
          }
        });
        if (!bool) {
          this.showFailToast("请检查奖品配置是否正确");
          return;
        }
        console.log(
          {
            title,
            startTime: startTime,
            endTime: endTime,
            prizeInfoList,
          },
          "time"
        );
        generateRule({
          title,
          startTime: new Date(startTime).getTime(),
          endTime: new Date(endTime).getTime(),
          prizeInfoList,
        }).then((res) => {
          if (res.success) {
            this.setData({
              rule: res.data,
              hasEditChangePrize: false,
            });
          }
        });
      } else {
        this.showFailToast("请填写完整信息");
      }
    },

    onCloseDialog(data) {
      switch (data) {
        case "group":
          this.setData({
            showGroup: false,
          });
          return;
        case "prize":
          this.setData({
            showPrize: false,
            prizeDialogData: {},
          });
          return;
        case "baby":
          this.setData({
            showBaby: false,
          });
          return;
        case "link":
          this.setData({
            showLink: false,
          });
          return;
      }
    },
    backList() {
      this.$page.$router.push("/activity/list");
    },
  },
});
