import { getAuthUserInfo } from 'tbcc-sdk-ts/lib/core/tbFn'
import { useEffect } from 'react'
import { commonToast } from 'tbcc-sdk-ts/lib/core/tb'

// 授权
export function useAuth(callback = noopFn) {
  const authUserInfo = async() => {
    const info = await getAuthUserInfo().catch(err => {
      console.log('未授权成功', err)
      commonToast('点击右上角，打开授权开关，重进活动即可参与')
    })
    if (info) {
      callback(info)
    }
  }
  useEffect(() => {
    authUserInfo()
  }, [])

  return {}
}