/** @format */

import { BaseDao } from '../sdk'
import { ACTIVITY_INSTANCE } from '../db'

export default class InstanceService {
  activityinstanceDao: IBaseDao
  context: Context
  constructor(context: Context) {
    this.activityinstanceDao = new BaseDao(context, ACTIVITY_INSTANCE)
  }

  //保存商家授权信息
  async saveInstanceInfo(instanceInfo) {
    return await this.activityinstanceDao.insertOne({
      ...instanceInfo,
      updateTime: Date.now(),
      createTime: Date.now()
    })
  }

  //查找商家授权信息
  async findInstanceInfo(openId: string) {
    return await this.activityinstanceDao.find({ openId })
  }

  //更新商家授权信息
  async updateInstanceInfo(openId: string, updateinfo) {
    return await this.activityinstanceDao.update(
      { openId },
      {
        $set: {
          ...updateinfo,
          updateTime: Date.now()
        }
      }
    )
  }

  async getMiniAppInstanceInfoByNick(userNick: string) {
    return await this.activityinstanceDao.find({ userNick })
  }
}
